/// @description Calc Angles / XY
//Legs
var goal_leg1y=sin(current_time/1000)*15;
var goal_leg2y=cos(current_time/1000)*15;
leg1y=lerp(leg1y,goal_leg1y,0.2);
leg2y=lerp(leg2y,goal_leg2y,0.2);
leg1x=x-40;
leg2x=x-30;
legangle=sin((x-xstart)/40)*20;
//Body
var goal_body_y=sin(current_time/1000)*15;
body_y=lerp(body_y,goal_body_y,0.2);
//Neck
var goal_neck_angle=90+(distance_to_point(Player.x,Player.y)/2);
neck_angle=lerp(neck_angle,goal_neck_angle,0.1);
//Head
headx=x+lengthdir_x(100,neck_angle-45);
heady=y+lengthdir_y(100,neck_angle-45);
var goal_head_angle=point_direction(headx,heady,Player.x,Player.y)-180;
head_angle=lerp(head_angle,goal_head_angle,0.1);
//Arm
var goal_arm_angle=point_direction(x,y,Player.x,Player.y);
arm_angle=lerp(arm_angle,goal_arm_angle,0.3);
//Cannon
var goal_cannon_angle=point_direction(x+lengthdir_x(70,arm_angle-45),y+lengthdir_y(70,arm_angle-45),Player.x,Player.y);
cannon_angle=lerp(cannon_angle,goal_cannon_angle,0.4);
if (state==STATES.normal)
	{
	//Collision checking
	x+=hsp;
	if (place_meeting(x,y,Block))
		hsp=-hsp;
	if (x<room_width/2)
		hsp=abs(hsp);
	//Timer for shooting
	if (time<=0)
		{
		if (phase==2)
			time=irandom_range(45,60);
		else
			time=irandom_range(60,120);
		with(instance_create_layer(x+lengthdir_x(70,arm_angle-45)-20,y+lengthdir_y(70,arm_angle-45)+body_y+20,layer,attack_array[shot_number]))
			{
			hsp=lengthdir_x(5,other.cannon_angle);
			vsp=lengthdir_y(5,other.cannon_angle);
			}
		shot_number+=1;
		if (shot_number>=array_length_1d(attack_array))
			shot_number=0;
		}
	time--;
	//Die
	if (hp<=0)
		{
		if (phase==1)
			{
			phase=2;
			hp=3;
			}
		else
			{
			instance_destroy();
			instance_create_layer(300,400,layer,Door);
			}
		with(ShotDanger)instance_destroy();
		with(FakeShot)instance_destroy();
		for(var i=0;i<120;i++)
			{
			with(instance_create_depth(x,y,-100,Particle))
				{
				direction=random_range(i*(3)-5,i*(3)+5);
				}
			}
		}
	}