/// @description Insert description here
// You can write your code in this editor

var bbox_side;

key_up = keyboard_check(ord("W"));
key_down = keyboard_check(ord("S"));
key_right = keyboard_check(ord("D"));
key_left = keyboard_check(ord("A"));

hsp = (key_right - key_left) * 5;
vsp = (key_down - key_up) * 5;

if (hsp > 0) bbox_side = bbox_right;
else bbox_side = bbox_left;

if (tilemap_get_at_pixel(controller_obj.tilemap_layer, bbox_side + hsp, bbox_top) >= controller_obj.wall_start) or (tilemap_get_at_pixel(controller_obj.tilemap_layer, bbox_side + hsp, bbox_bottom) >= controller_obj.wall_start)
	{
		if (hsp > 0) x = x - (x mod cell_size) + 31 - (bbox_right - x);
		else x = x - (x mod cell_size) - (bbox_left - x);
		hsp = 0;
	}
	
if (vsp > 0) bbox_side = bbox_bottom;
else bbox_side = bbox_top;
	
if (tilemap_get_at_pixel(controller_obj.tilemap_layer, bbox_left, bbox_side + vsp) >= controller_obj.wall_start) or (tilemap_get_at_pixel(controller_obj.tilemap_layer, bbox_right, bbox_side + vsp) >= controller_obj.wall_start)
	{
		if (vsp > 0) y = y - (y mod cell_size) + 31 - (bbox_bottom - y);
		else y = y - (y mod cell_size) - (bbox_top - y);
		vsp = 0;
	}

x += hsp;
y += vsp;

if mouse_check_button_pressed(mb_left) and charge > 0
	{
		new_bullet = instance_create_layer(x, y, "Instances", player_bullet_obj);
		audio_play_sound(shoot, 1, false);
		charge -= 1;
		
		with(new_bullet)
			{
				image_index = player_obj.image_index;
			}
	}

if mouse_wheel_up()
	{
		if image_index == 2
			{
				image_index = 0;		
			}
		else
			{
				image_index += 1;
			}
	}
	
if mouse_wheel_down()
	{
		if image_index == 0
			{
				image_index = 2;
			}
		else
			{
				image_index -= 1;
			}
	}

if instance_position(x, y, enemy_obj) and controller_obj.player_state == "normal"
	{
		audio_play_sound(playerhit, 1, false);
		hit_points -= 1;
		controller_obj.player_state = "immune";
		alarm[0] = 60;
	}
	
if instance_position(x, y, enemy_bullet_obj) and controller_obj.player_state == "normal"
	{
		audio_play_sound(playerhit, 1, false);
		hit_points -= 1;
		controller_obj.player_state = "immune";
		alarm[0] = 60;
	}
	
if instance_position(x, y, boss_bullet_obj) and controller_obj.player_state == "normal"
	{
		audio_play_sound(playerhit, 1, false);
		hit_points -= 1;
		controller_obj.player_state = "immune";
		alarm[0] = 60;
	}
	
if hit_points == 0
	{
		controller_obj.player_state = "dead"
		instance_destroy();
	}
	

	
