//
// Simple passthrough fragment shader
//
varying vec2 v_vTexcoord;
varying vec4 v_vColour;

uniform vec3 lightColor;

void main()
{
	vec4 fColor = v_vColour * texture2D( gm_BaseTexture, v_vTexcoord ) * vec4(lightColor, 1.0);
	float f = 1.0 - clamp(fColor.r + fColor.g + fColor.b, 0.0, 1.0);
    gl_FragColor = fColor + vec4(lightColor, 1.0) * 0.2 * f;
}
