varying vec2 v_vTexcoord;
varying vec4 v_vColour;

uniform vec3 lightColor;
uniform vec3 flashLight;

void main()
{
	float flashStrength = flashLight.z * clamp((1.0 - 0.005 * length(flashLight.xy - gl_FragCoord.xy) + 0.7), 0.0, 1.0);
	
	vec3 trueLightColor = lightColor + vec3(1.0) * flashStrength;
	trueLightColor = min(trueLightColor, vec3(1.0)); //vec3(min(lightColor.r, 1.0), min(lightColor.g, 1.0), min(lightColor.b, 1.0));
	
	//vec4 incol = texture2D( gm_BaseTexture, v_vTexcoord );
	//// normal lensing
	//vec4 normal = vec4(v_vColour.rgb, 1.0) * texture2D( gm_BaseTexture, v_vTexcoord ) * vec4(trueLightColor, 1.0);
	vec4 incol = vec4(v_vColour.rgb, 1.0) * texture2D( gm_BaseTexture, v_vTexcoord );
	// normal lensing
	vec4 normal = incol * vec4(trueLightColor, 1.0);
	
	// special lensing
	float is_special = 1.0 - floor(v_vColour.a + 0.5);
	float sumOrig = incol.r + incol.g + incol.b;
	//float special_passes = 1.0 - clamp( ceil(sumOrig - dot(incol.rgb, trueLightColor)), 0.0, 1.0);
	float special_passes = 1.0 - float((sumOrig - dot(incol.rgb, trueLightColor)) > 0.5);
	//float special_passes = float( dot(incol.rgb, trueLightColor) > 1.5 );
	//bool rpass = bool(v_vColour.r <= 0.5 || (v_vColour.r * lightColor.r) > 0.0);
	//bool gpass = bool(v_vColour.g <= 0.5 || (v_vColour.g * lightColor.g) > 0.0);
	//bool bpass = bool(v_vColour.b <= 0.5 || (v_vColour.b * lightColor.b) > 0.0);
	//float special_passes = float( rpass && bpass && true );
	
	float ss = sin((gl_FragCoord.x + gl_FragCoord.y)*0.5);
	ss = ss * 0.1 + 0.9;
	//special_passes = 1.0;
	//vec4 special = vec4(normal.rgb * special_passes, 1.0) * ((sin((gl_FragCoord.x + gl_FragCoord.y)*0.15) + 1.0) * 0.2 + 0.8);
	//vec4 special = vec4(ss*vec3(0.8, 0.5, 0.0), 1.0); 
	vec4 special = vec4(normal.rgb * ss * special_passes, 1.0);
	
	// composite of normal and special
	vec4 outCol = special * is_special + normal * (1.0 - is_special);
	
	// determine if this is actually black (we'll brighten it slightly by the lightColor)
	float sum = outCol.r + outCol.g + outCol.b;
	float f = 1.0 - clamp(sum, 0.0, 1.0);
	vec4 background = vec4(trueLightColor, 1.0) * 0.2 * f;	
	
	outCol.a = incol.a;
    gl_FragColor = outCol + background;
}