/// @description Insert description here
// You can write your code in this editor

depth = -y;

var time_passed = (delta_time / 1000000);

time_alive += time_passed;

if (time_alive >= 65) {
	instance_destroy();
}

switch (state) {
	case Turret.scan:
		if (scan_waiting) {
			if (scan_wait_timer > 5.0) {
				scan_waiting = false;
				if (scan_dir) {
					scan_dir = 0;
				} else {
					scan_dir = 1;
				}
			} else {
				scan_wait_timer += time_passed;	
			}
		} else {
			if (scan_dir) {
				facing_dir += 1;
			} else {
				facing_dir -= 1;
			}
			if (random(1000) < 1) {
				scan_waiting = true;	
				scan_wait_timer = 0;
			}
		}
	
		if (instance_exists(obj_zombie)) {
			var nearest_zombie = instance_nearest(x, y, obj_zombie),
				collision_check = collision_line(x, y, nearest_zombie.x, nearest_zombie.y, obj_solid, false, true);
			
			if (distance_to_object(nearest_zombie) < 500) && (!collision_check) {
				target = nearest_zombie;
				state = Turret.attack;
			}
		}
	break;
	case Turret.attack:
		if (!instance_exists(target)) {
			target = noone;
			state = Turret.scan;
			scan_wait_timer = 0;
			scan_waiting = true;
		} else {
			facing_dir = point_direction(x, y, target.x, target.y);
			
			if (!shot_fired) {
				shot_fired = true;
				shot_timer = 0;
				var bullet = instance_create_depth(x, y, -y+10, obj_turret_bullet);
				bullet.master = self.master;
				bullet.angle_dir = facing_dir;
				ammo--;
				
				if (ammo <=0) {
					state = Turret.reload;	
					reload_timer = 0;
					target = noone;
				}
			} else {
				if (shot_timer >= 0.6) {
					shot_fired = false;
					shot_timer = 0;
				}
				shot_timer += time_passed;	
			}
		}
	break;
	case Turret.reload:
		if (reload_timer >= 3.0) {
			target = noone;
			state = Turret.scan;
			reload_timer = 0;
		} else {
			reload_timer += time_passed;	
		}
	break;
}