/// @description Insert description here
// You can write your code in this editor

depth = -y;

var nearest_player = instance_nearest(x, y, obj_player),
	dist_to_player = distance_to_object(nearest_player),
	dist_to_coords = distance_to_point(target_x, target_y),
	collision_check = collision_line(x, y, nearest_player.x, nearest_player.y, obj_solid, true, true),
	time_passed = (delta_time/1000000),
	pixel_distance = (current_spd * time_passed);
	
time_alive += time_passed;

if (time_alive >= 60) {
	instance_destroy();	
}

switch (state) {

	case Enemy.active:
		
		if (dist_to_player <= 600) {
			if (!collision_check) {
				state = Enemy.curious;
				target_x = nearest_player.x;
				target_y = nearest_player.y;
			}
		}
		
		if (dist_to_coords < 30) {
			state = Enemy.wait;
		}
		
		if (distance_to_object(obj_nexus) < 200) {
			state = Enemy.suicidal;
		}
		
	break;
	
	case Enemy.curious:
	
		if (dist_to_coords < 30) {
			state = Enemy.wait;
		} else {
			if (dist_to_player <= 300) && (!collision_check) {
				state = Enemy.attack;
			}
		}
		
	break;
	
	case Enemy.attack:
	
		target_x = nearest_player.x;
		target_y = nearest_player.y;
		
		if (dist_to_player > 800) {
			state = Enemy.active;
			target_x = room_width/2;
			target_y = room_height/2;
		}
		
	break;
	
	case Enemy.wait:
	
		if (dist_to_player <= 600) && (!collision_check) {
			state = Enemy.curious;
			target_x = nearest_player.x;
			target_y = nearest_player.y;
		}
		
	break;
	
	case Enemy.hurt:
	
		enemy_timer++;
		
		if (enemy_timer >= enemy_timer_max) {
			enemy_timer = 0;
			state = Enemy.active;
			target_x = player_last_hit_by.x;
			target_y = player_last_hit_by.y;
		} else {
			target_x = x + lengthdir_x(pixel_distance, knockback_dir);
			target_y = y + lengthdir_y(pixel_distance, knockback_dir);
		}
	break;
	
	case Enemy.suicidal:
		target_x = obj_nexus.x;
		target_y = obj_nexus.y;
		
		if (distance_to_object(obj_nexus) < 5) {
			move_contact_solid(point_direction(x, y, target_x, target_y), -1);
			
			if (distance_to_object(obj_nexus) < 2) {
				suicide_timer += (delta_time/1000000);
				
				if (suicide_timer > 1.2) {
					event_perform(ev_collision, obj_nexus);
				}
			}
		}
	break;
}

move_enemy(pixel_distance, point_direction(x, y, target_x, target_y));

if (on_Fire) {
	hp -= 0.3;
	image_blend = c_red;
}

if (hp <= 0) {
	Game.zombies_killed++;
	Game.kills_to_nextWave--;
	instance_destroy();	
}

hp = clamp(hp, 0, 100);

if (distance_to_object(obj_nexus) < 50) {
	state = Enemy.suicidal;	
}