/// class_ability(class, ability)
/// @arg class
/// @arg ability

var getClass = argument[0],
	getAbility = argument[1];
	
switch (getClass) {
	case Class.Soldier:
		if (getAbility = Input.ABILITY1) {
			//ability 1: ammo drop
			var drop = instance_create_depth(x, y, -y+10, obj_pickup);
			drop.master = self.id;
			drop.class = Class.Soldier;
		} else {
			//ability 2: grenade
			var grenade = instance_create_depth(x, y, -y+5, obj_grenade);
			grenade.master = self.id;
			grenade.current_dir = self.angle_dir;
		}
	break;
	case Class.Medic:
		if (getAbility = Input.ABILITY1) {
			//ability 1: healthpack drop
			var drop = instance_create_depth(x, y, -y+10, obj_pickup);
			drop.master = self.id;
			drop.class = Class.Medic; 
		} else {
			//ability 2: revive player
			var temp_list = ds_list_create(),
				allies_healed = collision_circle_list(x, y, 200, obj_player, false, false, temp_list, false);
			
			for (var i=0; i<ds_list_size(temp_list); i++) {
				var thisAlly = temp_list[| i];
				
				if (thisAlly.dead) {
					thisAlly.dead = false;
				}
				
				thisAlly.hp = thisAlly.maxHP;
			}
			
			ds_list_destroy(temp_list);
		}
	break;
	case Class.Engineer:
		if (getAbility = Input.ABILITY1) {
			//ability 1: deploy turret
			var turret = instance_create_depth(x, y, -y+10, obj_turret);
			turret.master = self.id;
		} else {
			//ability 2: deploy barrier
			var barrier = instance_create_depth(x, y, -y+10, obj_barrier);
			barrier.master = self.id;
			barrier.image_angle = angle_dir;
		}
	break;
	case Class.Pyro:
		if (getAbility = Input.ABILITY1) {
			//ability 1: incendiary ammo
			var drop = instance_create_depth(x, y, -y+10, obj_pickup);
			drop.master = self.id;
			drop.class = Class.Pyro;
		} else {
			//ability 2: knockback
			var temp_list = ds_list_create(),
				zombies_hit = collision_circle_list(x, y, 240, obj_zombie, false, false, temp_list, false);
			
			for (var i=0; i<ds_list_size(temp_list); i++) {
				var thisZombie = temp_list[| i];
				
				thisZombie.state = Enemy.hurt;
				thisZombie.enemy_timer = 0;
				thisZombie.enemy_timer_max = (5 * room_speed);
				thisZombie.player_last_hit_by = self.id;
				thisZombie.on_Fire = true;
				thisZombie.knockback_dir = point_direction(x, y, thisZombie.x, thisZombie.y);
			}
			
			ds_list_destroy(temp_list);
		}
	break;
}