/// class_primary_fire(class)

var getClass = argument[0],
	spawn_angle = self.angle_dir - 25,
	create_x = x + lengthdir_x(24, spawn_angle),
	create_y = y + lengthdir_y(24, spawn_angle);

switch (getClass) {
	case Class.Soldier:
		var bullet = instance_create_depth(create_x, create_y, myGun.depth + 10, obj_bullet);
		bullet.class = getClass;
		bullet.current_spd = 2000;
		bullet.angle_dir = self.angle_dir;
		bullet.master = self.id;
		bullet.incendiary = false;
		if (incendiary) {
			bullet.incendiary = true;
		}
	break;
	case Class.Medic:
		var bullet = instance_create_depth(create_x, create_y, myGun.depth + 10, obj_bullet);
		bullet.class = getClass;
		bullet.current_spd = 400;
		bullet.angle_dir = self.angle_dir;
		bullet.master = self.id;
		bullet.incendiary = false;
		if (incendiary) {
			bullet.incendiary = true;
		}
	break;
	case Class.Engineer:
		for (var i=0; i<7; i++) {
			var spread = (self.angle_dir + i-4),
				bullet = instance_create_depth(create_x, create_y, myGun.depth + 10, obj_bullet);
			bullet.class = getClass;
			bullet.current_spd = (800 + (choose(-1, 1) + random(3)));
			bullet.angle_dir = (spread + (choose(-1, 1) * random(2)));
			bullet.master = self.id;
			bullet.image_yscale = choose(-1,1);
			bullet.incendiary = false;
			if (incendiary) {
				bullet.incendiary = true;
			}
		}
	break;
	case Class.Pyro:
		var bullet = instance_create_depth(create_x, create_y, myGun.depth + 10, obj_bullet);
		bullet.class = getClass;
		bullet.current_spd = 120;
		bullet.angle_dir = self.angle_dir;
		bullet.master = self.id;
		bullet.incendiary = false;
		if (incendiary) {
			bullet.incendiary = true;
		}
	break;
}