/// @description Init
// You can write your code in this editor

enums();

phase = Phase.Yellow;
wave = 0;
wave_isActive = false;
wave_timer = 0;

zombies_killed = 0;
max_zombies = get_maxZombies(wave);
kills_to_nextWave = get_kills_to_nextWave(wave);

//ai pathfinding
cell_width = 16;
cell_height = 16;

var	hcells = room_width div cell_width,
	vcells = room_height div cell_height;

grid = mp_grid_create(0, 0, hcells, vcells, cell_width, cell_height);
	
mp_grid_add_instances(grid, obj_solid, false);

//create players
for (var i=0; i<ds_map_size(Controller.player_map); i++) {
	var potential_x = irandom_range(670, 1330),
		potential_y = irandom_range(670, 1330);
	
	while (collision_circle(potential_x, potential_y, 32, obj_solid, false, true)) {
		potential_x = irandom_range(670, 1330);
		potential_y = irandom_range(670, 1330);
	}
	
	var newPlayer = instance_create_depth(potential_x, potential_y, -potential_y, obj_player);
		newPlayer.slot = i;
		
	Controller.player_map[? string(i)] = newPlayer;
	
	if (gamepad_button_check(i, gp_face1)) {
		with (newPlayer) {
			class_change(Class.Soldier);	
		}
	} else if (gamepad_button_check(i, gp_face2)) {
		with (newPlayer) {
			class_change(Class.Medic);	
		}
	} else if (gamepad_button_check(i, gp_face3)) {
		with (newPlayer) {
			class_change(Class.Engineer);	
		}
	} else if (gamepad_button_check(i, gp_face4)) {
		with (newPlayer) {
			class_change(Class.Pyro);	
		}
	} else {
		with (newPlayer) {
			class_change(slot);	
		}
	}
}