/// @desc  Move camera with cursor
if (player_can_act) {
  // Player camera control
  if (mouse_wheel_up() && Player.zoom_out_level > 1) {
    Player.zoom_out_level = max(1, Player.zoom_out_level - 1);
    var __len = point_distance(x, y, mouse_x, mouse_y), __dir = point_direction(x, y, mouse_x, mouse_y);
    __len = __len / (Player.zoom_out_level+1) * Player.zoom_out_level;
    x += lengthdir_x(__len, __dir);
    y += lengthdir_y(__len, __dir);
  }
  if (mouse_wheel_down()) {
    Player.zoom_out_level = min(Player.zoom_out_level + 1, 3);
    x = camera_get_view_x(camera) + camera_get_view_width(camera) / 2;
    y = camera_get_view_y(camera) + camera_get_view_height(camera) / 2;
  }
  zoom_out_level = Player.zoom_out_level;
  
  if (is_undefined(drag_x) || is_undefined(drag_y)) {
    if (Game.mouse_instance == noone) {
      System.cursor = cr_size_all;
      if (mouse_check_button_pressed(mb_left)) {
        drag_x = window_mouse_get_x();
        drag_y = window_mouse_get_y();
      }
    }
  } else if (mouse_check_button(mb_left)) {
    System.cursor = cr_size_all;
    x -= (window_mouse_get_x() - drag_x) / window_get_width() * camera_get_view_width(camera);
    y -= (window_mouse_get_y() - drag_y) / window_get_height() * camera_get_view_height(camera);
    x = clamp(x, (240 / 2) * zoom_out_level, room_width - 1 - (240 / 2) * zoom_out_level);
    y = clamp(y, (135 / 2) * zoom_out_level, room_height - 1 - (135 / 2) * zoom_out_level);
    drag_x = window_mouse_get_x();
    drag_y = window_mouse_get_y();
  } else {
    drag_x = undefined;
    drag_y = undefined;
  }
} else {
  drag_x = undefined;
  drag_y = undefined;
  
  // Move camera around
  var __camx = x, __camy = y, __zoom_out = zoom_out_level;
  switch (Game.turn_taker) {
    case char.dog: {
      __camx = mean(obj_doggo.bbox_left, obj_doggo.bbox_right);
      __camy = mean(obj_doggo.bbox_top, obj_doggo.bbox_bottom);
      __zoom_out = Player.zoom_out_level;
    } break;
    case char.resident: {
      if (instance_exists(Game.current_resident)) {
        var __id = Game.current_resident;
        __camx = mean(__id.bbox_left, __id.bbox_right);
        __camy = mean(__id.bbox_top, __id.bbox_bottom);
        __zoom_out = 1;
      }
    } break;
  }
  x = lerp(x, __camx, .2);
  y = lerp(y, __camy, .2);
  zoom_out_level = __zoom_out;
}

camera_set_view_size(camera, lerp(camera_get_view_width(camera), 240 * zoom_out_level, .2), lerp(camera_get_view_height(camera), 135 * zoom_out_level, .2));