/// @desc  Draw info
var __show = my_turn;
if (__show || (Game.mouse_instance == id && player_can_act)) {
  // Name
  var __zoom = lerp(Camera.zoom_out_level, 1, .5);
  draw_set_color(c_black);
  draw_set_font(fnt_names);
  draw_set_halign(fa_center);
  draw_set_valign(fa_top);
  draw_text_transformed(room_x_to_gui_x(draw_x + 10 + .5), room_y_to_gui_y(draw_y + 5), name, .5 / __zoom, .5 / __zoom, 0);
  draw_text_transformed(room_x_to_gui_x(draw_x + 10), room_y_to_gui_y(draw_y + 5 - .5), name, .5 / __zoom, .5 / __zoom, 0);
  draw_text_transformed(room_x_to_gui_x(draw_x + 10 - .5), room_y_to_gui_y(draw_y + 5), name, .5 / __zoom, .5 / __zoom, 0);
  draw_text_transformed(room_x_to_gui_x(draw_x + 10), room_y_to_gui_y(draw_y + 5 + .5), name, .5 / __zoom, .5 / __zoom, 0);
  draw_set_color(c_white);
  draw_text_transformed(room_x_to_gui_x(draw_x + 10), room_y_to_gui_y(draw_y + 5), name, .5 / __zoom, .5 / __zoom, 0);
}

// Indicators
var __ind = 0;
var __hunger = hunger_meter / hunger_meter_max;
var __anger = anger_meter / anger_meter_max;
var __bored = bored_o_meter / bored_o_meter_max;
var __poo = poo_meter / poo_meter_max;
if (__anger < .6) {
  __anger = min(max(__anger, __hunger, __bored, __poo), .5);
}
// General mood
if (__anger >= .6) {
  __ind[array_length_1d(__ind)] = 2;
} else if (__anger >= .4) {
  __ind[array_length_1d(__ind)] = 1;
} 
// Poo
if (__poo >= .4) {
  __ind[array_length_1d(__ind)] = 3;
}
// Hunger
if (__hunger >= .4) {
  __ind[array_length_1d(__ind)] = 4;
}
// Bored
if (__bored >= .6) {
  __ind[array_length_1d(__ind)] = 6;
}
if (!is_array(__ind) && __show) {
  __ind[0] = 0;
}

if (is_array(__ind)) {
  var __x = room_x_to_gui_x(mean(bbox_left, bbox_right) - x + draw_x) - array_length_1d(__ind) * (12 / Camera.zoom_out_level) / 2, __y = room_y_to_gui_y(bbox_top - 20 - y + draw_y);
  for (var i=0; i<array_length_1d(__ind); i++) {
    draw_sprite_ext(spr_mood_indicators, __ind[i], __x + i * (12 / Camera.zoom_out_level), __y, 1 / Camera.zoom_out_level, 1 / Camera.zoom_out_level, 0, c_white, 1);
  }
}