/// @desc  Move
var __old_x = draw_x, __old_y = draw_y;
xscale_previous = xscale;
if (draw_x != x) {
  xscale = sign(x - draw_x);
  draw_x += sign(x - draw_x) * 2;
}
if (draw_y != y) {
  draw_y += sign(y - draw_y) * 2;
}
if (jump_yoffset == 0 && (draw_x != x || draw_y != y)) {
  jump_vspeed = -min(max(abs(x - draw_x), abs(y - draw_y)) / 2, 4);
}

// Initiate movement
if (done) {
  image_alpha -= .01;
  if (image_alpha <= 0) {
    instance_destroy();
  }
} else {
  if (image_alpha < 1) {
    image_alpha += .01;
  }
  if (!instance_exists(target) || instance_place(x, y, target)) {
    my_turn = 0;
    have_moved = 1;
    Game.wait = 1 sec;
    done = 1;
    sfx_play(snd_death_sucess);
    Game.total_dead++;
    with (target) {
      instance_destroy();
    }
  } else if (my_turn && !Game.wait) {
    if (x == __old_x && y == __old_y) {
      var __dir = round(point_direction(x, y, target.x, target.y) / 90) * 90, __dist = max(20, round(min(point_distance(x, y, target.x, target.y), 40) / 20) * 20);
      x += lengthdir_x(__dist, __dir);
      y += lengthdir_y(__dist, __dir);
    } else {
      // Stop movement
      if (x == draw_x && y == draw_y) {
        my_turn = 0;
        have_moved = 1;
        Game.wait = 1 sec;
      }
    }
  }
}

// Physics
jump_yoffset += jump_vspeed;
jump_vspeed++;
if (jump_yoffset >= 0) {
  jump_yoffset = 0;
  jump_vspeed = 0;
}