/// @desc  Game update
mouse_instance = instance_position(room_x_to_gui_x(mouse_x), room_y_to_gui_y(mouse_y), par_hud_element);
if (instance_exists(obj_message)) {
  mouse_instance = obj_message.id;
}
if (mouse_instance != noone) {
  cursor = cr_handpoint;
}

if (wait > 0) {
  wait--;
  exit;
}
if (paused) {
  if (!keyboard_check_pressed(vk_pause) && !keyboard_check_pressed(ord("P"))) {
    exit;
  }
  paused = 0;
}
if (!instance_exists(Level) || instance_exists(obj_message)) {
  exit;
}
if (Level.done) {
  total_poo = instance_number(obj_poop_on_floor);
  with (obj_reaper) {
    instance_destroy();
  }
  with (obj_resident) {
    if (anger_meter == anger_meter_max) {
      total_angry++;
    } else if (anger_meter / anger_meter_max >= .4) {
      total_angry += .5;
    }
    if (poo_meter / poo_meter_max >= .4 || hunger_meter / hunger_meter_max >= .4 || bored_o_meter / bored_o_meter_max >= .6) {
      total_not_happy++;
    }
    total_spilled_food = instance_number(obj_food);
  }
  
  level_score = 42 - total_angry * 2 - total_not_happy - total_spilled_food / 2 - total_dead * 4 - total_fled * 4;
  if (level_score > level_highscore) {
    score -= level_highscore;
    score += level_score;
    level_highscore = level_score;
  }
  
  ini_open(save_file);
  ini_write_real(general_data, "total_score", score);
  ini_write_real(level_data, "highscore", level_highscore);
  ini_close();
  
  room_goto_next();
}

// Hande states
switch (turn_taker) {
  // Dog/player movement
  case char.dog: {
    if (end_turn) {
      turn_taker = char.resident;
      wait = 1 sec;
      // Gather list of residents to move
      ds_list_clear(resident_list_for_moving);
      with (obj_resident) {
        // Going through changes
        var __attention = 0;
        // Live
        add_live(-1);
        live_changed = live_o_meter != live_o_meter_previous;
        live_o_meter_previous = live_o_meter;
        // Pooping
        if (place_meeting(x, y, obj_toilet_tile) && poo_meter > poo_meter_max / 2) {
          __attention = 1;
          add_hunger(5);
        } else if (poo_meter >= 0) {
          // Poo-meter
          add_poo(1);
          if (poo_meter >= poo_meter_max * .4 && poo_meter_previous < poo_meter_max * .4) {
            __attention = 1;
          }
          if (poo_meter >= poo_meter_max * .6 && poo_meter_previous < poo_meter_max * .6) {
            __attention = 1;
          }
          if (poo_meter == poo_meter_max) {
            __attention = 1;
            add_hunger(5);
            add_anger(10);
            add_live(-5);
          }
        }
        poo_changed = (poo_meter != poo_meter_previous && poo_meter >= poo_meter_max * .4 && poo_meter_previous < poo_meter_max * .4);
        poo_meter_previous = poo_meter;
        // Hunger
        add_hunger(1);
        if (hunger_meter >= hunger_meter_max * .4) {
          if (hunger_meter_previous < hunger_meter_max * .4) {
            __attention = 1;
          }
          add_anger(1);
        }
        if (hunger_meter >= hunger_meter_max * .6) {
          if (hunger_meter_previous < hunger_meter_max * .6) {
            __attention = 1;
          }
          add_anger(2);
        }
        if (hunger_meter == hunger_meter_max) {
          add_anger(3);
          add_live(-1);
        }
        hunger_changed = (hunger_meter != hunger_meter_previous && hunger_meter >= hunger_meter_max * .4 && hunger_meter_previous < hunger_meter_max * .4);
        hunger_meter_previous = hunger_meter;
        // Anger
        with (instance_place(x + 10, y, obj_resident)) {
          if (anger_meter > other.anger_meter) {
            with (other) {
              add_anger(3);
            }
          }
        }
        with (instance_place(x, y - 10, obj_resident)) {
          if (anger_meter > other.anger_meter) {
            with (other) {
              add_anger(3);
            }
          }
        }
        with (instance_place(x - 10, y, obj_resident)) {
          if (anger_meter > other.anger_meter) {
            with (other) {
              add_anger(3);
            }
          }
        }
        with (instance_place(x, y + 10, obj_resident)) {
          if (anger_meter > other.anger_meter) {
            with (other) {
              add_anger(3);
            }
          }
        }
        if (anger_meter >= anger_meter_max * .4) {
          if (anger_meter_previous < anger_meter_max * .4) {
            __attention = 1;
          }
        }
        if (anger_meter >= anger_meter_max * .6) {
          if (anger_meter_previous < anger_meter_max * .6) {
            __attention = 1;
          }
          add_anger(1);
        }
        if (anger_meter == anger_meter_max) {
          add_anger(1);
        }
        anger_changed = (anger_meter != anger_meter_previous && anger_meter >= anger_meter_max * .4 && anger_meter_previous < anger_meter_max * .4);
        anger_meter_previous = anger_meter;
        // Boredness
        add_boredom(1);
        if (bored_o_meter >= bored_o_meter_max * .4 && bored_o_meter_previous < bored_o_meter_max * .4) {
          __attention = 1;
        }
        if (bored_o_meter >= bored_o_meter_max * .6) {
          if (bored_o_meter_previous < bored_o_meter_max * .6) {
            __attention = 1;
          }
          add_hunger(1);
        }
        if (bored_o_meter == bored_o_meter_max) {
          add_anger(1);
        }
        boredom_changed = (bored_o_meter != bored_o_meter_previous && bored_o_meter >= bored_o_meter_max * .6 && bored_o_meter_previous < bored_o_meter_max * .6);
        bored_o_meter_previous = bored_o_meter;
        // If demanding attention
        if (__attention) {
          ds_list_add(other.resident_list_for_moving, id);
          have_moved = 1;
        }
        // Move
        else {
          var __chance = 2 + alzheimers;
          __chance *= 1 - (place_meeting(x, y, obj_sucktion_tile) * .75);
          __chance *= !((tilemap_meeting(x + 10, y, "Blocker_tiles") || place_meeting(x + 10, y, obj_resident)) && (tilemap_meeting(x, y - 10, "Blocker_tiles") || place_meeting(x, y - 10, obj_resident)) && (tilemap_meeting(x - 10, y, "Blocker_tiles") || place_meeting(x - 10, y, obj_resident)) && (tilemap_meeting(x, y + 10, "Blocker_tiles") || place_meeting(x, y + 10, obj_resident)));
          __chance *= !(Player.leashed_to == id);
          if (random(__chance) >= 1 || object_index == obj_reaper) {
            ds_list_add(other.resident_list_for_moving, id);
            have_moved = 0;
          }
        }
      }
      // Add a reaper
      if (!instance_exists(obj_reaper)) {
        var __reap = 0, __target = noone;
        with (obj_resident) {
          if (live_o_meter == 0) {
            __reap = 1;
            __target = id;
            break;
          }
        }
        if (__reap) {
          __reap = instance_create_layer(20, 300, "Game_instances", obj_reaper);
          __reap.target = __target;
          ds_list_insert(other.resident_list_for_moving, 0, __reap);
        }
      }
      break;
    }
  } break;
  // Residents
  case char.resident: {
    if (ds_list_size(resident_list_for_moving)) {
      var __id = resident_list_for_moving[| 0];
      current_resident = __id;
      if (!instance_exists(__id)) {
        ds_list_delete(resident_list_for_moving, 0);
        current_resident = noone;
        break;
      }
      if (__id.have_moved) {
        // Actions
        with (__id) {
          // Toilet
          var __sfx = -1;
          if (place_meeting(x, y, obj_toilet_tile)) {
            if (poo_meter >= poo_meter_max * .4) {
              __sfx = sfx_play(choose(snd_parp_1, snd_parp_2, snd_parp_3));
            }
            poo_meter = 0;
          } else if (poo_meter == poo_meter_max) {
            __sfx = sfx_play(choose(snd_parp_1, snd_parp_2, snd_parp_3));
            instance_create_layer(x, y, "On_floor", obj_poop_on_floor);
            poo_meter = 0;
          } else if (poo_meter >= poo_meter_max * .4 && poo_changed) {
            __sfx = sfx_play(need_to_poop_sfx);
          }
          // Hunger
          if (!__sfx && hunger_meter >= hunger_meter_max * .4 && hunger_changed) {
            __sfx = sfx_play(hungry_sfx);
          }
          // Anger
          if (!__sfx && anger_meter >= anger_meter_max * .4 && anger_changed) {
            __sfx = sfx_play(angry_sfx);
          }
          // Boredom
          if (!__sfx && bored_o_meter >= bored_o_meter_max * .6 && boredom_changed) {
            __sfx = sfx_play(bored_sfx);
          }
        }
        // On with it!
        ds_list_delete(resident_list_for_moving, 0);
      } else if (__id.my_turn == 0) {
        __id.my_turn = 1;
        wait = 1 sec;
      }
    } else {
      // Post-movement actions
      current_resident = noone;
      // Next turn
      turn_taker = char.none;
    }
  } break;
  // Reset for next round
  default: {
    turn_taker = char.dog;
    obj_doggo.movement_points = 5;
    obj_doggo.extra_movement_points = 0;
    Player.exhausted = 0;
    turns_left--;
    wait = 1 sec;
    if (turns_left <= 0) {
      Level.done = 1;
      with (instance_create_layer(0, 0, "System_instances", obj_message)) {
        text = "I'm baaack! Let's see how good a boy you have been...";
      }
    }
  } break;
}

end_turn = 0;
previous_turn_taker = turn_taker;

// Mouse continued
if (mouse_instance == noone) {
  mouse_instance = instance_position(mouse_x, mouse_y + 8, obj_resident);
} else {
  System.cursor = cr_handpoint;
}
if (mouse_instance == noone) {
  mouse_instance = instance_position(mouse_x, mouse_y, obj_doggo);
}