/// @desc  Setup
// Inherit the parent event
event_inherited();

xoffset = 10;
yoffset = 5 + irandom(5);

jump_yoffset = 0;
jump_vspeed = 0;

xscale = -1;
xscale_previous = 1;

my_turn = 0;
have_moved = 0;

poo_meter_previous = 0;
anger_meter_previous = 0;
hunger_meter_previous = 0;
live_o_meter_previous = 0;
bored_o_meter_previous = 0;

poo_changed = poo_meter != poo_meter_previous;
anger_changed = anger_meter != anger_meter_previous;
hunger_changed = hunger_meter != hunger_meter_previous;
live_changed = live_o_meter != live_o_meter_previous;
boredom_changed = bored_o_meter != bored_o_meter_previous;

// Id
image_index = resident_id;
name = "No one";
base_color = c_white;
need_to_poop_sfx = snd_f_need_to_poop;
angry_sfx = snd_f_angry;
bored_sfx = snd_f_bored;
hungry_sfx = snd_f_hungry;
laugh_sfx = snd_f_laugh;
aww_sfx = snd_f_aww;
switch (resident_id) {
  case 0: {
    name = "Phyllis";
    base_color = c_olive;
  } break;
  case 1: {
    name = "Barbara";
    base_color = c_blue;
  } break;
  case 2: {
    name = "Elanor";
    base_color = c_purple;
  } break;
  case 3: {
    name = "Francis";
    base_color = c_aqua;
    need_to_poop_sfx = snd_f_need_to_poop;
    angry_sfx = snd_m_angry;
    bored_sfx = snd_m_bored;
    laugh_sfx = snd_m_laugh;
    aww_sfx = snd_m_aww;
  } break;
  case 4: {
    name = "Samuel";
    base_color = c_gray;
    need_to_poop_sfx = snd_f_need_to_poop;
    angry_sfx = snd_m_angry;
    bored_sfx = snd_m_bored;
    laugh_sfx = snd_m_laugh;
    aww_sfx = snd_m_aww;
  } break;
  case 5: {
    name = "Harris";
    base_color = c_fuchsia;
    need_to_poop_sfx = snd_f_need_to_poop;
    angry_sfx = snd_m_angry;
    bored_sfx = snd_m_bored;
    laugh_sfx = snd_m_laugh;
    aww_sfx = snd_m_aww;
  } break;
  case 6: {
    name = "Hansel";
    base_color = c_teal;
    need_to_poop_sfx = snd_f_need_to_poop;
    angry_sfx = snd_m_angry;
    bored_sfx = snd_m_bored;
    laugh_sfx = snd_m_laugh;
    aww_sfx = snd_m_aww;
  } break;
  case 7: {
    name = "Allen";
    base_color = c_dkgray;
    need_to_poop_sfx = snd_f_need_to_poop;
    angry_sfx = snd_m_angry;
    bored_sfx = snd_m_bored;
    laugh_sfx = snd_m_laugh;
    aww_sfx = snd_m_aww;
  } break;
  case 8: {
    name = "Sharon";
    base_color = c_maroon;
  } break;
  case 9: {
    name = "Loretta";
    base_color = c_orange;
  } break;
  case 10: {
    name = "Martha";
    base_color = c_silver;
  } break;
  case 11: {
    name = "Bob";
    base_color = c_green;
    need_to_poop_sfx = snd_f_need_to_poop;
    angry_sfx = snd_m_angry;
    bored_sfx = snd_m_bored;
    laugh_sfx = snd_m_laugh;
    aww_sfx = snd_m_aww;
  } break;
  case 12: {
    name = "Walker";
    base_color = c_yellow;
    need_to_poop_sfx = snd_f_need_to_poop;
    angry_sfx = snd_m_angry;
    bored_sfx = snd_m_bored;
    laugh_sfx = snd_m_laugh;
    aww_sfx = snd_m_aww;
  } break;
  case 13: {
    name = "Daisy";
    base_color = c_purple;
  } break;
  case 14: {
    name = "Sam";
    base_color = c_teal;
    need_to_poop_sfx = snd_f_need_to_poop;
    angry_sfx = snd_m_angry;
    bored_sfx = snd_m_bored;
    laugh_sfx = snd_m_laugh;
    aww_sfx = snd_m_aww;
  } break;
  case 15: {
    name = "Emma";
    base_color = c_red;
  } break;
}