/// @author		Simon Milfred
/// @func		  draw_sprite_on_point(sprite_index, image_index, x, y, inherit_image_vars*);
/// @desc		  Draws a sprite with the bottom center at the given coordinate.
/// @arg		  sprite_index
/// @arg		  image_index
/// @arg		  x
/// @arg		  y
/// @arg		  image_xscale
/// @arg		  image_yscale
/// @arg		  image_blend
/// @arg		  image_alpha
/// returns		n/a
var _spr = argument[0], _img = argument[1], _x = argument[2], _y = argument[3], _xscale = argument[4], _yscale = argument[5], _blend = argument[6], _alpha = argument[7];
var _uvs = sprite_get_uvs(_spr, _img);
var _tex = sprite_get_texture(_spr, _img);
var _width = _uvs[6] * sprite_get_width(_spr) * _xscale;
var _height = _uvs[7] * sprite_get_height(_spr) * _yscale;

draw_primitive_begin_texture(pr_trianglestrip, _tex); {
  // Bottom left
  draw_vertex_texture_color(_x - _width / 2, _y, 0, 1, _blend, _alpha);
  // Bottom right
  draw_vertex_texture_color(_x + _width / 2, _y, 1, 1, _blend, _alpha);
  // Top left
  draw_vertex_texture_color(_x - _width / 2, _y - _height, 0, 0, _blend, _alpha);
  // Top right
  draw_vertex_texture_color(_x + _width / 2, _y - _height, 1, 0, _blend, _alpha);
} draw_primitive_end();