/// @description Update lighting surface

if (!surface_exists(lightSurface)) {
	lightSurface = surface_create(surfaceWidth, surfaceHeight);
}

surface_set_target(lightSurface);
draw_clear_alpha(c_black, 1);

gpu_set_blendmode(bm_src_color);
with(objLightSource) {
	var cx = objCamera.x - other.surfaceWidth / 2;
	var cy = objCamera.y - other.surfaceHeight / 2;
	draw_sprite_ext(lightSprite, 0, x - cx, y - cy, lightScale, lightScale, lightAngle, c_white, lightAlpha);
	lightAngle += lightRotationSpeed;
	if (lightAngle >= 360.0) {
		lightAngle -= 360.0;
	}
	if (lightAngle < 0.0) {
		lightAngle += 360.0;
	}
}
gpu_set_blendmode(bm_normal);

surface_reset_target();
camera_apply(view_camera[0]);

var vx = objCamera.x - view_wport[0] / 2;
var vy = objCamera.y - view_hport[0] / 2;
draw_surface_ext(lightSurface, vx, vy, 1, 1, 0, c_white, surfaceAlpha);
