tmCollision = layer_tilemap_get_id("Platforms");
touchLeft = TileCollision(tmCollision, bbox_left - 1, bbox_top, bbox_left - 1, bbox_bottom);
touchRight = TileCollision(tmCollision, bbox_right + 1, bbox_top, bbox_right + 1, bbox_bottom);
touchTop = TileCollision(tmCollision, bbox_left, bbox_top - 1, bbox_right, bbox_top - 1);
touchBottom = TileCollision(tmCollision, bbox_left, bbox_bottom + 1, bbox_right, bbox_bottom + 1);

xMove = 0;
switch (state) {
	case playerState.INIT:
		x = xstart;
		y = ystart;
		image_speed = 1;
		sprite_index = sprPlayerIdle;
		image_xscale = 1;
		state = playerState.NORMAL;
		break;
	case playerState.NORMAL:
		PlayerControls();
		PlayerMovement();
		PlayerAnimation();
		break;
	case playerState.DYING:
		PlayerMovement();
		if (image_index + image_speed >= image_number) {
			image_speed = 0;
			alarm[0] = 1 * room_speed;
		}
		break;
	case playerState.DEAD:
		//objStatus.transState = transitionState.FADE_OUT;
		state = playerState.DEAD_FADEOUT;
		break;
	case playerState.DEAD_FADEOUT:
		if (objStatus.transState == transitionState.IDLE) {
			//objStatus.transState = transitionState.FADE_IN;
			if (x >= 0 && x < room_width && y >= 0 && y < room_height) {
				var deadPlayer = instance_create_layer(x, y, "DeadPlayers", objPlayerDead);
				deadPlayer.image_xscale = image_xscale;
			}
			state = playerState.INIT;
		}
		break;
		case playerState.LEVEL_FADEOUT:
			if (objStatus.transState == transitionState.IDLE) {
				alarm[1] = 1 * room_speed;
				state = playerState.LEVEL_DONE;
			}
			break;
		case playerState.LEVEL_DONE:
			break;
}
audio_listener_position(x, y, 0);
audio_listener_velocity(xSpd, ySpd, 0);
