/// @func InitView(view, height);
/// @desc Initialize the viewport and resize app surface
/// @arg {real} view Id of the view to setup
/// @arg {real} tileHeight Target height of the view in tiles

var view = argument0;
var tileHeight = argument1;
var windowWidth = window_get_width();
var windowHeight = window_get_height();
//show_debug_message("WindowHeight: " + string(windowHeight));

// Calculate a rounded pixels per unit
var initialViewHeight = tileHeight * TILE_SIZE; // 11*32=352
var initialPixelsPerUnit = windowHeight / initialViewHeight; // 1440/352=4.1, 1080/352=3.1
var pixelsPerUnit = floor(initialPixelsPerUnit); // round(4.1)=4, round(3.1)=3
//show_debug_message("PixelsPerUnit: " + string(pixelsPerUnit));

// Calculate final view size
var viewWidth = windowWidth / pixelsPerUnit; // 3440/5=688, 1920/4=480
var viewHeight = windowHeight / pixelsPerUnit; // 1440/5=288, 1080/4=270
//show_debug_message("ViewHeight: " + string(viewHeight));

// Update the viewport to use the full window size
view_wport[view] = viewWidth;
view_hport[view] = viewHeight;

// This gets rid of the annoying sub-pixels
surface_resize(application_surface, viewWidth, viewHeight);
display_set_gui_size(viewWidth, viewHeight);
