/// @func PlayerMovement()

xSpd += xMove * accel;
xSpd = clamp(xSpd, -maxSpeed, maxSpeed);
if ((xSpd < 0 && !touchLeft) || (xSpd > 0 && !touchRight)) x += xSpd;
if (xSpd < 0) {
	if (y < room_height - 8) {
		if (TileCollision(tmCollision, bbox_left, bbox_top, bbox_left, bbox_bottom)) {
			x = ((bbox_left + TILE_SIZE) & ~(TILE_SIZE - 1)) - (sprite_get_bbox_left(sprPlayerIdle) - sprite_get_xoffset(sprPlayerIdle));
			xSpd = 0;
		}
	}
}
if (xSpd > 0) {
	if (y < room_height - 8) {
		if (TileCollision(tmCollision, bbox_right, bbox_top, bbox_right, bbox_bottom)) {
			x = (bbox_right & ~(TILE_SIZE - 1)) - 1 - (sprite_get_bbox_right(sprPlayerIdle) - sprite_get_xoffset(sprPlayerIdle));
			xSpd = 0;
		}
	}
}

if (!touchBottom) ySpd += grav;
ySpd = clamp(ySpd, -maxFallSpeed, maxFallSpeed);
y += ySpd;
if (ySpd < 0) {
	if (y < room_height - 8) {
		if (TileCollision(tmCollision, bbox_left, bbox_top, bbox_right, bbox_top)) {
			y = ((bbox_top + TILE_SIZE) & ~(TILE_SIZE - 1)) - (sprite_get_bbox_top(sprPlayerIdle) - sprite_get_yoffset(sprPlayerIdle));
			ySpd = 0;
		}
	}
}
if (ySpd > 0) {
	if (y < room_height - 8) {
		if (TileCollision(tmCollision, bbox_left, bbox_bottom, bbox_right, bbox_bottom)) {
			y = (bbox_bottom & ~(TILE_SIZE - 1)) - 1 - (sprite_get_bbox_bottom(sprPlayerIdle) - sprite_get_yoffset(sprPlayerIdle));
			ySpd = 0;
		}
	} else {
		if (state == playerState.NORMAL) {
			audio_sound_pitch(sndDying, random_range(0.975, 1.0125));
			audio_play_sound(sndDying, 50, false);
			sprite_index = sprPlayerDying;
			state = playerState.DYING;
		}
	}
}
if (xMove == 0 && xSpd != 0) {
	xSpd *= 0.7;
}
