///platform_physics()

//gravity
vsp += grav;
if(vsp > 15) {
    vsp = 15;
}

// Vertical collisions
if(place_meeting(x,y+vsp,objBlock)) {
    while(!place_meeting(x,y+sign(vsp),objBlock)) {
        y += sign(vsp);
    }
    vsp = 0;
}
else {
    y += vsp;
}

// Horizontal collisions
repeat(abs(hsp)) {
    // Move up slope
    if (place_meeting(x + sign(hsp), y, objBlock) && !place_meeting(x + sign(hsp), y - 1, objBlock))
        y -= 1;
    // Move down slope
    if (!place_meeting(x + sign(hsp), y, objBlock) && !place_meeting(x + sign(hsp), y + 1, objBlock) && place_meeting(x + sign(hsp), y + 2, objBlock))
        y += 1;
	// move flat
    if (!place_meeting(x + sign(hsp), y, objBlock))
        x += sign(hsp); 
    else {
        hsp = 0;
        break;
    }
}