/// @description Insert description here
// You can write your code in this editor
if(global.paused) {
	return;	
}

if(dead) {
	rotation += 1;	
	y += curVspeed;
	curVspeed += TAN_GRAVITY;
	return;
}

var movingRight = false;
var movingLeft = false;
var wantsToJump = false;
isMoving = false;

if(gamepad_button_check(0, gp_face1) || keyboard_check(vk_space)) {
	wantsToJump = true;
}

var dx = 0;
var curLeftAxisH = gamepad_axis_value(0, gp_axislh);

if(curLeftAxisH > TAN_DEADZONE) {
	movingRight = true;	
	dx = curLeftAxisH > TAN_MAXZONE ? moveSpeedMax : moveSpeed;
}
if(keyboard_check(ord("D"))) {
	movingRight = true;
	dx = moveSpeedMax;
}

if(curLeftAxisH < -TAN_DEADZONE) {
	movingLeft = true;	
	dx = curLeftAxisH < -TAN_MAXZONE ? moveSpeedMax : moveSpeed;
}
if(keyboard_check(ord("A"))) {
	movingLeft = true;
	dx = moveSpeedMax;
}

//don't want any weird error with multiple key presses or directions
if(movingRight && movingLeft) {
	movingRight = false;
	movingLeft = false;
}


if(movingRight) {
	var colRight = instance_place(x+dx,y,objectBlock);
	if(colRight != noone) {
		dx = moveSpeed;
		colRight = instance_place(x+dx,y,objectBlock);
	}
	if(colRight == noone) {
		x += dx;	
		facingRight = true;
		isMoving = true;
		image_speed = dx == moveSpeedMax ? fastAnimationSpeed : regularAnimationSpeed;
	}
}
if(movingLeft) {
	var colLeft = instance_place(x-dx,y,objectBlock);
	if(colLeft != noone) {
		dx = moveSpeed;
		colLeft = instance_place(x-dx,y,objectBlock);
	}
	if(colLeft == noone) {
		x -= dx;
		facingRight = false;
		isMoving = true;
		image_speed = dx == moveSpeedMax ? fastAnimationSpeed : regularAnimationSpeed;
	}
}

var aboveBlock = instance_place(x,y-1,objectBlock);


//alright easy street is over... now it's time for gravity
//let's just move stuff now
if(wantsToJump && jumpCount > 0 && aboveBlock == noone) {
	jumpCount -= 1;
	curVspeed = -JUMPSPEED;	
	onGround = false;
	alarm[0] = -1;
	audio_play_sound(soundPlayerJump,0,false);
}

if(!place_meeting(x,y+1,objectBlock) && onGround) {
	onGround = false;	
	//let's go ahead and give some grace on the jumping
	alarm[0] = 12;
}

y += floor(curVspeed);
var movedY = floor(curVspeed);
if(!onGround) {
	curVspeed += TAN_GRAVITY;	
}

//so now we've moved
var touching = instance_place(x,y,objectBlock);
if(touching != noone) {
	//well we're touching something... 
	//lets do the top one first
	curVspeed = 0;
	
	if(y < touching.y) {
		//we are above the thing	
		//let's be on top of the thing
		y = touching.y - sprite_height;
		onGround = true;
		jumpCount = jumpTotal;
	}
	else {
		//OH SNAP WE'RE BELOW THE THING
		y = touching.y + touching.sprite_height;
	}
}

if(curVspeed >= MAXVSPEED) {
	curVspeed = MAXVSPEED;
}

if(curVspeed <= -MAXVSPEED) {
	curVspeed = -MAXVSPEED;	
}



var enemyTouch = instance_place(x,y,objectEnemySludge);
if(enemyTouch != noone) {
	if(!enemyTouch.dead) {
		dead = true;
		audio_play_sound(soundPlayerDeath,0,false);
		alarm[1] = 30;
		curVspeed = -2;
		if(global.currentCompanion != -1) {
			instance_destroy(global.currentCompanion);	
		}
		return;
	}
}


//OH GOSH I'M COPY PASTING CODE THAT IS LIKE 2 FEET AWAY!!! 
if(y+sprite_height>room_height) {
	dead = true;
	audio_play_sound(soundPlayerDeath,0,false);
	alarm[1] = 30;
	curVspeed = -2;
	if(global.currentCompanion != -1) {
		instance_destroy(global.currentCompanion);	
	}
}




