/// @desc Init world

// make math work
math_set_epsilon(0.001);
draw_set_font(font0);

//Extra space around the view
pixbuffer = 0;

//Get the view X,Y
viewX = camera_get_view_x( view_camera[0] );
viewY = camera_get_view_y( view_camera[0] );

//Create rectangle around view for activations
global.viewXstart = max(viewX - pixbuffer, 0);
global.viewYstart = max(viewY - pixbuffer, 0);
global.viewXend = min(viewX + camera_get_view_width(view_camera[0]) + pixbuffer, room_width);
global.viewYend = min(viewY + camera_get_view_height(view_camera[0]) + pixbuffer, room_height);

//store last x y to detect view moving
viewXlast = viewX;
viewYlast = viewY;

backID = layer_get_id("Background");
layer_hspeed(backID, -0.1);
global.backX = floor(layer_get_x(backID))
global.spawncount=0;

lane[0] = 112;
lane[1] = 152;
lane[2] = 192;
lane[3] = 232;
last_lane = 0;
killrest=false;

//Start spawns
var temp = lane[choose(0,1,2,3)]
var inst instance_create_layer(global.viewXend-16, temp, "ground", choose(obj_scientist, obj_soldier, obj_soldier) );
last_lane = temp;

audio_play_sound(SongForGm48_1, 0, true);