/// @description Update transition

switch(current_state)
{
	case TRAN_STATE.OFF:
	{
		break;
	}

	case TRAN_STATE.IN:
	{
		if(percent < 1.0)
		{
			percent += max((1-percent)/10, 0.01);
			percent = min(1, percent);
		}
		else
		{
			room_goto(next_room);
			current_state = TRAN_STATE.OUT;
		}
		break;
	}
	
	case TRAN_STATE.OUT:
	{
		if(percent > 0.0)
		{
			percent -= max((percent)/10, 0.01);
			percent = max(0, percent);
		}
		else
		{
			current_state = TRAN_STATE.OFF;
		}
		break;
	}
	
}