/// @description Movement and animation

key_left = keyboard_check(vk_left);
key_right = keyboard_check(vk_right);
key_jump = keyboard_check(vk_space);
on_floor = place_meeting(x, y+1, oWall);

xVel = (key_right - key_left) * RUN;
yVel += GRAV;


if(on_floor && key_jump)
{
	yVel = - JUMP;
}

if(place_meeting(x + xVel, y, oWall))
{
	while(!place_meeting(x + sign(xVel), y, oWall))
	{
		x += sign(xVel);
	}
	xVel = 0;
}

if(place_meeting(x, y + yVel, oWall))
{
	while(!place_meeting(x, y +  sign(yVel), oWall))
	{
		y += sign(yVel);
	}
	yVel = 0;
}

if(place_meeting(x + xVel, y + yVel, oWall))
{
	xVel = 0;
	yVel = 0;
}

x += xVel;
y += yVel;

// Animation
if(xVel == 0)
{
	image_speed = 0;
	image_index = 0;
}
else
{
	image_speed = 1;
	image_xscale = sign(xVel);
}


// Camera
/// @description Move camera to target

var x_cam =  x - w_half;
var y_cam =  y - h_half;
x_cam = clamp(x_cam, 0, room_width - w);
y_cam = clamp(y_cam, 0, room_height - h);
camera_set_view_pos(view_camera[0], x_cam, y_cam);