#region // DRAW COOLANT UI

draw_set_font(fnt_ui);
draw_set_color(c_midblue);
draw_set_halign(fa_left);
draw_set_valign(fa_top);

draw_text(9,8,"COOLANT");

var offset = 0;
var c = coolant;
var h = sprite_get_height(spr_coolant_ui);
var b = 8;

repeat(10)
{
	draw_set_alpha(0.25);
	draw_sprite(spr_coolant_ui,0,10,25+offset);
	draw_set_alpha(1);
	offset += h + b;
}

offset = 0;

repeat(c)
{
	draw_sprite(spr_coolant_ui,1,10,25+offset);
	offset += h + b;
}

#endregion

#region // DRAW INV UI

gpu_set_blendmode(bm_add);

draw_set_font(fnt_ui);
draw_set_color(c_orange);
draw_set_halign(fa_right);
draw_set_valign(fa_top);

draw_text(VPORT_WIDTH-9,8,"INVENTORY");

var offset = 0;
var c = inv_count;
var h = sprite_get_height(spr_inv_ui);
var b = 8;

repeat(10)
{
	draw_set_alpha(0.25);
	draw_sprite(spr_inv_ui,0,VPORT_WIDTH-10,25+offset);
	draw_set_alpha(1);
	offset += h + b;
}

offset = 0;

repeat(c)
{
	draw_sprite(spr_inv_ui,1,VPORT_WIDTH-10,25+offset);
	offset += h + b;
}

gpu_set_blendmode(bm_normal);

#endregion

#region // DRAW DESCRIPTION UI

if(game_state == STATE_EXPLORE)
{	
	gpu_set_blendmode(bm_add);
	
	draw_set_valign(fa_top);
	draw_set_halign(fa_center);
	
	if(obj_player.node.node_string == "transit hub")
	{
		draw_set_color(c_midblue);
	}
	else
	{
		draw_set_color(c_lime);
	}
	draw_set_font(fnt_location_title);
	draw_text(VPORT_WIDTH/2,80,string_upper(obj_player.node.node_string));
	
	draw_set_color(c_white);
	draw_set_font(fnt_location_title);
	
	// DRAW TEXT TO SCREEN
	
	var i;
	for(i=0; i<4; i++)
	{
		draw_set_colour(line[i,1]);
		draw_set_alpha(line[i,2]);
		draw_text(VPORT_WIDTH/2,180+(i*45)+line[i,3],line[i,0]);
	}
	//show_debug_message(string(line[1,0])+" + "+string(line[1,1])+" + "+string(line[1,2])+" + "+string(line[1,3]));
	
	gpu_set_blendmode(bm_normal);
} 

#endregion