#region // GAME INIT

randomize();

// Init coolant
coolant_max = 10;
coolant = coolant_max;

inv_max = 10;
inv_count = 0;

c_midblue = make_color_rgb(0,228,255);
c_iorange = make_colour_rgb(248,148,29);

#macro  STATE_INIT 0
#macro  STATE_OVERWORLD 1
#macro  STATE_EXPLORE 2
#macro	VPORT_WIDTH 960
#macro	VPORT_HEIGHT 540

game_state = STATE_INIT;

player_inv = ds_list_create();
ship_inv = ds_list_create();

#endregion

// INIT TEXT DISPLAY //

// LINE STRING
line[0,0] = "";
line[1,0] = "";
line[2,0] = "";
line[3,0] = "";

// LINE COLOUR
line[0,1] = c_white;
line[1,1] = c_white;
line[2,1] = c_white;
line[3,1] = c_white;

// LINE ALPHA
line[0,2] = 0;
line[1,2] = 0;
line[2,2] = 0;
line[3,2] = 0;

#macro LINE_YOFFSET 20

// LINE Y OFFSET
line[0,3] = LINE_YOFFSET;
line[1,3] = LINE_YOFFSET;
line[2,3] = LINE_YOFFSET;
line[3,3] = LINE_YOFFSET;

looted = false;
struck = false;
progress = 0;
enemy_alive = false;


// INIT TRIGGERS
#macro T_NEUTRAL 0
#macro T_STRIKE 1
#macro T_LOOT 2
#macro T_PROCEED 3
#macro T_DEPART 4
#macro T_SEND 5
#macro T_ESC 6

trigger = T_NEUTRAL;

// INIT ENCOUNTERS

// ENCOUNTER TYPES
#macro  ET_CONTINUE 0
#macro  ET_LOOT 1
#macro  ET_FIGHT 2
#macro  ET_TRAP 3
#macro  ET_END 4

// ENCOUNTER CONTENT
#macro EC_BODY_TEXT 0
#macro EC_STRIKE_TEXT 1
#macro EC_STRIKE_RESULT 2
#macro EC_LOOT_TEXT 3
#macro EC_LOOT_RESULT 4
#macro EC_CONTINUE_TEXT 5
#macro EC_CONTINUE_RESULT 6

encounters_list = ds_list_create();
encounter_type = -1;
encounter_text = "THIS TEXT SHOULD BE OVERWRITTEN";

// Populate encounters deck
ds_list_add(encounters_list,
ET_END,
ET_FIGHT,
ET_FIGHT,
ET_FIGHT,
ET_LOOT,
ET_LOOT
);

// LOOT DESCRIPTIONS
var i = 0;
loot_adj = ds_list_create();
ds_list_add(loot_adj,
"sealed",
"glowing",
"humming",
"armoured",
"large",
"small",
"tiny",
"hefty",
"strange",
"alien",
"damaged",
"cracked",
"unsettling",
"sturdy",
"cylindrical")
ds_list_add(loot_adj,
"partially melted",
"seared",
"frozen",
"remarkable",
"abberant",
"blackened",
"distended",
"elongated")
ds_list_shuffle(loot_adj);

var i = 0;
loot_noun = ds_list_create();
ds_list_add(loot_noun,
"strongbox",
"lockbox",
"case",
"casket",
"barrel",
"canister",
"cylinder",
"container",
"chest",
"cabinet",
"vault",
"safe",
"capsule",
"tank",
"vessel")
ds_list_add(loot_noun,
"vial",
"alembic",
"cistern",
"repository",
"receptacle",
"carton",
"crate",
"package")
ds_list_shuffle(loot_noun);

// ENEMY DESCRIPTIONS
var i = 0;
fight_adj = ds_list_create();
ds_list_add(fight_adj,
"looming",
"threatening",
"hideous",
"enraged",
"large",
"hostile",
"hateful",
"antagonistic",
"strange",
"alien",
"damaged",
"vicious",
"dangerous",
"barbarous",
"ferocious")
ds_list_add(fight_adj,
"monsterous",
"abhorrent",
"contaminated",
"degraded",
"pulsating",
"immolated",
"rotting",
"hovering")
ds_list_shuffle(fight_adj);

var i = 0;
fight_noun = ds_list_create();
ds_list_add(fight_noun,
"drone",
"defence bot",
"sentry",
"sentinal",
"sludge",
"robot",
"droid",
"android",
"bot",
"figure",
"raider",
"slime",
"xenomorph",
"assault mech",
"mutant arachnid")
ds_list_add(fight_noun,
"amebic horror",
"auton",
"autonomous unit",
"cyborg",
"automata",
"hominoid",
"disembodied entity",
"predator")
ds_list_shuffle(fight_noun);


// ENCOUNTER RESULT
#macro ER_NOTHING 0
#macro ER_GAIN_COOLANT 1
#macro ER_LOSE_COOLANT 2
#macro ER_GAIN_ITEM 3
#macro ER_LOSE_ITEM 4

// Item lists
item_list = ds_list_create();

ds_list_add(item_list,
"Star charts",
"Germplasm",
"Rosetta opus",
"Ancient embryo",
"Iridium ingot",
"Astatine nucleus",
"Hydrogen-2 isotope",
"Tritium ingot",
"Immortal conciousness",
"Antarctic ice core",
"Extremophile microbe",
"Edict ledger",
"Genome database",
"Holographic recording",
"Bitcoin wallet"
)
ds_list_shuffle(item_list);