/// @description 
//Resolution
//#macro RES_W 320
//#macro RES_H 180
#macro RES_W 180
#macro RES_H 320
//#macro RES_W 480
//#macro RES_H 270
#macro RES_SCALE 2

#macro CAM_SMOOTH 0.1

// Enable views
view_enabled = true;
view_visible[0] = true;

// Create camera
camera = camera_create_view(0, 0, RES_W / RES_SCALE, RES_H / RES_SCALE);
view_set_camera(0, camera);

doPan = false;

// Resize window & application surface
var display_width = display_get_width();
var display_height = display_get_height();

var window_width = RES_W * RES_SCALE;
var window_height = RES_H * RES_SCALE;

game.GUIWIDTH = window_width
game.GUIHEIGHT = window_height
game.GUIWIDTHHALF = window_width * .5
game.GUIHEIGHTHALF = window_height * .5


window_set_size(window_width, window_height);
surface_resize(application_surface, window_width, window_height);

display_set_gui_size(window_width, window_height);

// Center window
window_set_position(display_width/2 - window_width/2, display_height/2 - window_height/2);

// Mouse previous
mouse_x_previous = device_mouse_x_to_gui(0);
mouse_y_previous = device_mouse_y_to_gui(0);