/// @description

// system
rad		= 8;
numArms = 4;
faceTimer = room_speed * 5

// instance
movingUp	= false;
movingDown	= false;
faceIndex = 0

// { arm, originX, originY }
arms = [];

var da = 360 / numArms;
for (var i = 0; i < 360; i += da) {
	var dtr = degtorad(i + da / 2);
	
	var xx		= cos(dtr) * rad + x
	var yy		= sin(dtr) * rad + y
	var offset	= yy - y;
	
	var arm = instance_create_depth(xx, yy, depth, Tentacle, { pointAngle: dtr })
	array_push(arms, { arm: arm, originX: xx, originY: yy, offset: offset })
}

// [key (as letter), armInd, isPressed, menuItem]
ds_keys = ds_grid_create(4, 4)
ds_keys[# 0, 0] = "F"
ds_keys[# 1, 0] = 0
ds_keys[# 2, 0] = false
ds_keys[# 3, 0] = noone

ds_keys[# 0, 1] = "A"
ds_keys[# 1, 1] = 1
ds_keys[# 2, 1] = false
ds_keys[# 3, 1] = noone

ds_keys[# 0, 2] = "S"
ds_keys[# 1, 2] = 2
ds_keys[# 2, 2] = false
ds_keys[# 3, 2] = noone

ds_keys[# 0, 3] = "D"
ds_keys[# 1, 3] = 3
ds_keys[# 2, 3] = false
ds_keys[# 3, 3] = noone

// eyes
eyes = [ 
	{x: -3, y: -3 },
	{x: 3,  y: -3 }
]