/// @Desc fnEaseLinear(t, b, c, d)
/// @arg Time Current Time
/// @arg Begin Where animation begins
/// @arg Change Change between start and end
/// @arg Total Total animation time
function funEaseLinear(t, b, c, d) {
	return c * t / d + b;
}

/// @function fnEaseExpoOut(t, b, c, d)
function funEaseExpoOut(t, b, c, d) {
	return (t == d) ? b + c : c * (-power(2, -10 * t / d) + 1) + b;
}

/// @function fnEaseExpoIn(t, b, c, d)
function funEaseExpoIn(t, b, c, d) {
	return (t == 0) ? b : c * power(2, 10 * (t/d - 1)) + b;
}

/// @function fnEaseExpoInOut(t, b, c, d)
function funEaseExpoInOut(t, b, c, d) {
	if (t == 0) return b;
	
	if (t == d) return b + c;
	
	var dee = d / 2;
	var tee = t / dee;
	
	if (tee < 1) return c / 2 * power(2, 10 * (t - 1)) + b;
	return c / 2 * (-power(2, -10 * --t) + 2) + b;
}

/// @function fnEaseBounceOut(t, b, c, d)
function funEaseBounceOut(argument0, argument1, argument2, argument3) {
	
	var argZero = argument0 / argument3;
	
	if (argZero < (1/2.75)) {
		return argument2*(7.5625*argZero*argZero) + argument1;
	} else if (argZero < (2/2.75)) {
		argZero-=(1.5/2.75)
		var postFix = argZero;
		return argument2*(7.5625*(postFix)*argZero + .75) + argument1;
	} else if (argZero < (2.5/2.75)) {
		argZero-=(2.25/2.75);
		var postFix = argZero;
		return argument2*(7.5625*(postFix)*argZero + .9375) + argument1;
	} else {
		argZero-=(2.625/2.75);
		var postFix = argZero;
		return argument2*(7.5625*(postFix)*argZero + .984375) + argument1;
	}
}

/// @function fnEaseBounceIn(t, b, c, d)
function funEaseBounceIn(t, b, c, d) {
	return c - fnEaseBounceOut(d - t, 0, c, d) + b;
}

/// @function fnEaseBackIn(t, b, c, d)
function funEaseBackIn(t, b, c, d) {

	var s = 1.70158;
	var newTee = t / d;
	var postFix = newTee;
	return c * (postFix)*newTee*((s+1)*newTee - s) + b;
}

/// @function fnEaseBackOut(t, b, c, d)
function funEaseBackOut(t, b, c, d) {
	var s = 1.70158;
	var zero = t / d - 1;
	return c*((zero)*zero*((s+1)*zero + s) + 1) + b;
}

function funEaseBackInOut(t, b, c, d) {
	var s = 1.70158;
	
	var dee = d / 2;
	var tee = t / dee;
	
	if (tee < 1) {
		//var val = 
		var ess = s * (1.525);
		return c / 2 * (t * t * (((ess)+1) * t - s)) + b;
	}
	
	var t2 = t - 2;
	var postFix = t2;
	var ess = s * (1.525);
	return c/2*((postFix)*t*(((ess)+1)*t + s) + 2) + b;
}


function funEaseSineIn(t, b, c, d) {
	return -c * cos(t/d * (pi / 2)) + c + b;
}
function funEaseSineOut(t, b, c, d) {	
	return c * sin(t/d * (pi / 2)) + b;	
}

function funEaseSineInOut(t, b, c, d) {
	return -c / 2 * (cos(pi * t / d) - 1) + b;
}

/// @desc Wave(from, to, duration, offset)
/// @arg From Starting pos
/// @arg To Ending pos
/// @arg Duration Time
/// @arg Offset Offset
function funEaseWave(argument0, argument1, argument2, argument3) {

	// Returns a value that will wave back and forth between [from-to] over [duration] seconds
	// Examples
	//      image_angle = Wave(-45,45,1,0)  -> rock back and forth 90 degrees in a second
	//      x = Wave(-10,10,0.25,0)         -> move left and right quickly

	// Or here is a fun one! Make an object be all squishy!! ^u^
	//      image_xscale = Wave(0.5, 2.0, 1.0, 0.0)
	//      image_yscale = Wave(2.0, 0.5, 1.0, 0.0)

	var a4 = (argument1 - argument0) * 0.5;
	return argument0 + a4 + sin((((current_time * 0.001) + argument2 * argument3) / argument2) * (pi*2)) * a4;
}


/// @arg Center Of oscillation
/// @arg Amplitude Height
/// @arg Time Higher is more frequent
/// @arg Offset Time
function funEaseNewWave(argument0, argument1, argument2, argument3) {

	var center = argument0;
	var amp = argument1;
	var time = argument2;
	var offset = argument3;

	var mstos = current_time * 0.001;

	return center + sin(-(mstos * time) + offset) * amp;
}
