/// @description
draw_set_font(Font1)
draw_set_halign(fa_center)
draw_set_valign(fa_middle)

var labelW = 10;
var labelH = 20;

// draw arm labels
for (var i = 0; i < numArms; i++) {
	
	var xx = arms[i].arm.segments[1].a.x
	var yy = arms[i].arm.segments[1].a.y
	
	var newX = funMapRange(xx, 0, 160, 0, 640)
	var newY = funMapRange(yy, 0, 90, 0, 360)
	
	drawBox(newX, newY, labelW + 2, labelH + 2, c_black)
	drawBox(newX, newY, labelW, labelH, c_white)
	
	// [key (as letter), armInd, isPressed]
	var c = ds_keys[# 2, i] ? c_green : c_red;
	
	draw_text_color(newX, newY, string(ds_keys[# 0, i]), c, c, c, c, 1);
}

// draw up/down labels
var xx = game.GUIWIDTHHALF - labelW
var yy = labelH * .5
drawBox(xx, yy, labelW + 2, labelH + 2, c_black)
drawBox(xx, yy, labelW, labelH, c_white)

var c = movingUp ? c_green : c_red;
draw_text_color(xx, yy, "W", c, c, c, c, 1)

xx = game.GUIWIDTHHALF + labelW
drawBox(xx, yy, labelW + 2, labelH + 2, c_black)
drawBox(xx, yy, labelW, labelH, c_white)
draw_text_color(xx, yy, "E", c, c, c, c, 1)

xx = game.GUIWIDTHHALF - labelW
yy = game.GUIHEIGHT - labelH * .5
drawBox(xx, yy, labelW + 2, labelH + 2, c_black)
drawBox(xx, yy, labelW, labelH, c_white)

c = movingDown ? c_green : c_red;
draw_text_color(xx, yy, "X", c, c, c, c, 1)

xx = game.GUIWIDTHHALF + labelW
drawBox(xx, yy, labelW + 2, labelH + 2, c_black)
drawBox(xx, yy, labelW, labelH, c_white)
draw_text_color(xx, yy, "C", c, c, c, c, 1)