function Vector2(_x, _y) constructor {
	x = _x;
	y = _y;
	
	add = function(_vec2) {
		x += _vec2.x;
		y += _vec2.y;
	}
	
	addGetCopy = function(_x, _y) {
		return new Vector2(x + _x, y + _y);
	}
	
	copy = function() {
		return new Vector2(x, y);
	}
	
	heading = function() {
		return arctan2(y, x)
	}
	
	mag = function(_mag) {
		return sqrt(magSq())
	}
	
	magSq = function() {
		return x * x + y * y;
	}
	
	mult = function(_num) {
		x *= _num;
		y *= _num;
	}
	
	normalize = function() {
		var len = mag();
		if (len != 0) mult(1 / len);
	}
	
	set = function(_x, _y) {
		x = _x;
		y = _y;
	}
	
	setMag = function(_num) {
		normalize()
		mult(_num)
	}
	
	sub = function(_x, _y) {
		x -= _x;
		y -= _y;
	}
	
	subGetCopy = function(_x, _y) {
		return new Vector2(x - _x, y - _y);
	}
}

function Segment(_x, _y, _angle, _len) constructor {
	a = new Vector2(_x, _y);
	b = new Vector2(0, 0);
	
	base = new Vector2(_x, _y);
	
	angle = _angle;
	length = _len;
	
	calcB = function() {
		var dx = length * cos(angle);
		var dy = length * sin(angle);
		b.set(a.x + dx, a.y + dy);
	}
	
	setA = function(_vec2) {
		a = _vec2.copy();
		calcB()
	}
	
	follow = function(_tx, _ty) {
		
		if (_tx == 0 && _ty == 0) exit;
		
		var tar = new Vector2(_tx, _ty);
		var dir = tar.subGetCopy(a.x, a.y)
		
		angle = dir.heading();
		dir.setMag(length);
		dir.mult(-1);
		a = tar.addGetCopy(dir.x, dir.y)
	}
	
	step = function() {
		calcB();
	}
	
	draw = function(_w) {
		draw_line_width(a.x, a.y, b.x, b.y, _w);
	}
}