/// @description 

key_right = keyboard_check(ord("D")) || keyboard_check(vk_right);
key_left = keyboard_check(ord("A")) || keyboard_check(vk_left);
key_jump = keyboard_check_pressed(vk_space);
key_hit = keyboard_check_pressed(vk_shift);

var move = key_right - key_left;

hsp = move * movespd;
vsp += grv;

//Jump Control
canjump--;

//Get Facing Directions
var _dir = sign(hsp);


if (key_jump) && (canjump > 0)
{
	vsp = -6;
	sprite_index = spr_PlayerJump;
	canjump = 0;
}



//Swing Control
if (!cantswing > 0) && (key_hit)
	{
			with (instance_create_layer(x + sprite_width, y, layer, obj_Swing))
			{
				image_xscale = obj_Player.image_xscale;
			}
			
			sprite_index = spr_PlayerHit;
			cantswing = 1;
			isswing = 1
	}


//Horizontal Collision
if (place_meeting(x + hsp, y, obj_Wall))
{
	while (!place_meeting(x + sign(hsp), y, obj_Wall))
	{
		x += sign(hsp);	
	}
	hsp = 0;
}

x += hsp;

//Vertical Collision
if (place_meeting(x, y + vsp, obj_Wall))
{
	while (!place_meeting(x, y + sign(vsp), obj_Wall))
	{
		y += sign(vsp);	
	}
	vsp = 0;
}

y += vsp;



if (!place_meeting(x, y + 1, obj_Wall))
{
	sprite_index = spr_PlayerJump;
	
}
else
{
	canjump = 8;	
}

 if (hsp == 0)
	{
		if (!isswing) sprite_index = spr_PlayerIdle;
	}
	else
	{
		sprite_index = spr_PlayerWalk;
		image_xscale = sign(hsp);
	}

	





