/// @description Wstaw opis w tym miejscu
// W tym edytorze możesz zapisać swój kod
part_system = part_system_create();
part_heart = part_type_create();
part_type_life(part_heart,20,40);
part_type_direction(part_heart,45,135,0,0);
part_type_gravity(part_heart,0,0);
part_type_speed(part_heart,0.5,0.7,-0.01,0);
part_type_sprite(part_heart,spr_heart,false,false,false);
part_type_size(part_heart,0.3,0.4,-0.001,0);



map_surface = noone;
map_sprite = noone;

unlocked_skins = 1;
//window_set_fullscreen(true);

draw_set_font(fn_normal)
map_string = "";
rift_available = true;
rift_radius = 48;
rift_start_radius = 16;
mouse_clicked_x = 0;
mouse_clicked_y = 0;

tutorial = true

game_speed = 0;
game_speeds = [60, 120, 240];
game_over = false;

editor_type = 0;
editor_types = [obj_person, obj_point];
editor_group = 0;
editor_wait = 0;
editor_point_number = 0;
editor_move = noone;

back_music = audio_play_sound(snd_background_100,2,true,1,0);
back_position = audio_sound_get_track_position(back_music)/audio_sound_length(back_music);
back_track = 0;
back_tracks = [snd_background_100,snd_background_120,snd_background_140]

maps = [
"[{\"x\":620.0,\"y\":297.0,\"p\":[{\"wait\":0.0,\"x\":614.0,\"y\":297.0},{\"wait\":0.0,\"x\":20.0,\"y\":301.0}]},{\"x\":13.0,\"y\":299.0,\"p\":[{\"wait\":0.0,\"x\":20.0,\"y\":301.0},{\"wait\":0.0,\"x\":613.0,\"y\":298.0}]}]",
"[{\"x\":141.0,\"y\":243.0,\"p\":[{\"x\":156.0,\"wait\":0.0,\"y\":246.0},{\"x\":316.0,\"wait\":0.0,\"y\":251.0},{\"x\":320.0,\"wait\":0.0,\"y\":331.0}]},{\"x\":536.0,\"y\":288.0,\"p\":[{\"x\":522.0,\"wait\":0.0,\"y\":288.0},{\"x\":207.0,\"wait\":0.0,\"y\":285.0},{\"x\":210.0,\"wait\":0.0,\"y\":169.0}]}]",
"[{\"x\":203.0,\"y\":158.0,\"p\":[{\"x\":202.0,\"wait\":0.0,\"y\":173.0},{\"x\":201.0,\"wait\":0.0,\"y\":285.0},{\"x\":380.0,\"wait\":0.0,\"y\":288.0},{\"x\":376.0,\"wait\":0.0,\"y\":154.0}]},{\"x\":66.0,\"y\":190.0,\"p\":[{\"x\":84.0,\"wait\":0.0,\"y\":191.0},{\"x\":328.0,\"wait\":120.0,\"y\":187.0},{\"x\":462.0,\"wait\":0.0,\"y\":184.0}]}]",
"[{\"x\":58.0,\"y\":28.0,\"p\":[{\"x\":73.0,\"wait\":0.0,\"y\":41.0},{\"x\":160.0,\"wait\":0.0,\"y\":93.0},{\"x\":231.0,\"wait\":0.0,\"y\":134.0},{\"x\":293.0,\"wait\":0.0,\"y\":165.0},{\"x\":357.0,\"wait\":0.0,\"y\":204.0},{\"x\":420.0,\"wait\":0.0,\"y\":237.0},{\"x\":485.0,\"wait\":0.0,\"y\":275.0},{\"x\":552.0,\"wait\":0.0,\"y\":308.0}]},{\"x\":66.0,\"y\":310.0,\"p\":[{\"x\":89.0,\"wait\":0.0,\"y\":300.0},{\"x\":139.0,\"wait\":0.0,\"y\":273.0},{\"x\":186.0,\"wait\":0.0,\"y\":243.0},{\"x\":241.0,\"wait\":60.0,\"y\":209.0},{\"x\":288.0,\"wait\":0.0,\"y\":180.0},{\"x\":327.0,\"wait\":0.0,\"y\":148.0},{\"x\":385.0,\"wait\":0.0,\"y\":113.0},{\"x\":425.0,\"wait\":0.0,\"y\":92.0},{\"x\":470.0,\"wait\":0.0,\"y\":68.0},{\"x\":514.0,\"wait\":0.0,\"y\":44.0}]}]",
"[{\"x\":499.0,\"y\":275.0,\"p\":[{\"x\":500.0,\"wait\":600.0,\"y\":202.0},{\"x\":497.0,\"wait\":0.0,\"y\":64.0}]},{\"x\":540.0,\"y\":67.0,\"p\":[{\"x\":542.0,\"wait\":0.0,\"y\":84.0},{\"x\":544.0,\"wait\":0.0,\"y\":258.0},{\"x\":447.0,\"wait\":0.0,\"y\":242.0},{\"x\":451.0,\"wait\":0.0,\"y\":86.0},{\"x\":364.0,\"wait\":0.0,\"y\":84.0},{\"x\":361.0,\"wait\":0.0,\"y\":210.0},{\"x\":292.0,\"wait\":0.0,\"y\":215.0}]},{\"x\":18.0,\"y\":162.0,\"p\":[{\"x\":37.0,\"wait\":0.0,\"y\":162.0},{\"x\":588.0,\"wait\":0.0,\"y\":164.0}]},{\"x\":21.0,\"y\":134.0,\"p\":[{\"x\":37.0,\"wait\":0.0,\"y\":136.0},{\"x\":588.0,\"wait\":0.0,\"y\":138.0}]}]",
"[{\"x\":269.0,\"y\":330.0,\"p\":[{\"x\":268.0,\"wait\":0.0,\"y\":205.0},{\"x\":376.0,\"wait\":0.0,\"y\":206.0}]},{\"x\":556.0,\"y\":204.0,\"p\":[{\"x\":195.0,\"wait\":0.0,\"y\":204.0}]},{\"x\":390.0,\"y\":294.0,\"p\":[{\"x\":376.0,\"wait\":0.0,\"y\":295.0},{\"x\":269.0,\"wait\":0.0,\"y\":295.0},{\"x\":268.0,\"wait\":0.0,\"y\":205.0},{\"x\":374.0,\"wait\":0.0,\"y\":205.0}]},{\"x\":256.0,\"y\":204.0,\"p\":[{\"x\":268.0,\"wait\":0.0,\"y\":205.0},{\"x\":374.0,\"wait\":0.0,\"y\":206.0},{\"x\":377.0,\"wait\":0.0,\"y\":295.0},{\"x\":269.0,\"wait\":0.0,\"y\":295.0}]}]",
"[{\"x\":97.0,\"p\":[{\"x\":126.0,\"y\":172.0,\"wait\":0.0},{\"x\":484.0,\"y\":172.0,\"wait\":0.0}],\"y\":172.0},{\"x\":57.0,\"p\":[{\"x\":85.0,\"y\":201.0,\"wait\":0.0},{\"x\":485.0,\"y\":201.0,\"wait\":0.0}],\"y\":201.0},{\"x\":15.0,\"p\":[{\"x\":46.0,\"y\":240.0,\"wait\":0.0},{\"x\":486.0,\"y\":240.0,\"wait\":0.0}],\"y\":240.0},{\"x\":405.0,\"p\":[{\"x\":385.0,\"y\":71.0,\"wait\":0.0},{\"x\":435.0,\"y\":93.0,\"wait\":0.0},{\"x\":383.0,\"y\":122.0,\"wait\":0.0},{\"x\":439.0,\"y\":158.0,\"wait\":0.0},{\"x\":386.0,\"y\":173.0,\"wait\":0.0},{\"x\":441.0,\"y\":218.0,\"wait\":0.0},{\"x\":390.0,\"y\":236.0,\"wait\":0.0}],\"y\":34.0},{\"x\":335.0,\"p\":[{\"x\":316.0,\"y\":70.0,\"wait\":0.0},{\"x\":355.0,\"y\":93.0,\"wait\":0.0},{\"x\":314.0,\"y\":121.0,\"wait\":0.0},{\"x\":361.0,\"y\":160.0,\"wait\":0.0},{\"x\":316.0,\"y\":179.0,\"wait\":0.0},{\"x\":357.0,\"y\":218.0,\"wait\":0.0},{\"x\":314.0,\"y\":242.0,\"wait\":0.0}],\"y\":28.0},{\"x\":251.0,\"p\":[{\"x\":234.0,\"y\":70.0,\"wait\":0.0},{\"x\":274.0,\"y\":92.0,\"wait\":0.0},{\"x\":235.0,\"y\":123.0,\"wait\":0.0},{\"x\":280.0,\"y\":156.0,\"wait\":0.0},{\"x\":230.0,\"y\":183.0,\"wait\":0.0},{\"x\":283.0,\"y\":220.0,\"wait\":0.0},{\"x\":240.0,\"y\":240.0,\"wait\":0.0}],\"y\":31.0}]"
//"[{\"p\":[{\"x\":277.0,\"y\":27.0,\"wait\":0.0},{\"x\":280.0,\"y\":200.0,\"wait\":0.0},{\"x\":294.0,\"y\":331.0,\"wait\":0.0}],\"x\":278.0,\"y\":18.0},{\"p\":[{\"x\":42.0,\"y\":195.0,\"wait\":0.0},{\"x\":290.0,\"y\":194.0,\"wait\":0.0},{\"x\":614.0,\"y\":211.0,\"wait\":0.0}],\"x\":25.0,\"y\":192.0}]",
]

menu_anim = 0;
menu_anim_grow = true;
menu_alert = "";

menu_buttons = function(){
	if(room != rm_editor)
	{
		rift_available = true;
		
		var _b = instance_create_layer(16,room_height/2,"Instances",obj_button)
		_b.width = 64;
		_b.height = 32;
		_b.text = "Edit"
		_b.action = function(){menu_hide(); edit_map_button()}

		_b = instance_create_layer(16,room_height/2+40,"Instances",obj_button)
		_b.width = 64;
		_b.height = 32;
		_b.text = "Load"
		_b.action = function(){load_map_button()}
		
		_b = instance_create_layer(16,room_height/2+80,"Instances",obj_button)
		_b.width = 64;
		_b.height = 32;
		_b.text = "Quit"
		_b.action = function(){menu_hide();window_set_fullscreen(false); game_end()}
		
		for(var i = 0; i < array_length(maps); i++)
		{
			_b = instance_create_layer(16+(i mod 5)*32,60+(i div 5)*32,"Instances",obj_button)
			_b.width = 32;
			_b.height = 32;
			_b.text = ""+string(i+1);
			var _s = obj_control.maps[i];
			_b.value = _s;
			_b.action = function(_a){menu_hide(); load_map(_a); }
		}
	}
	else
	{
		var _b = instance_create_layer(16,2,"Instances",obj_button)
		_b.width = 24;
		_b.height = 16;
		_b.text = "End"
		_b.action = function(){menu_hide(); finish_edit_button()}
	}
}

menu_hide = function(){
	with obj_button
		instance_destroy();
		
	if(tutorial)
	{
		menu_anim = 0.01 ;
		menu_alert = "You have Just One chance to create a time rift.\nClick to create the rift then move up to speed up\nor move down to slow down objects inside it.\nAll it takes for people to fall in love is Just One bump.\nYou can toogle the game speed in the right top corner.\nClick outside this message to dismiss it."
		tutorial = false;
	}
}


increase_music_speed = function(_tn = noone){
	if(not _tn == noone)
	{
		if(back_track < 2)
			back_track += 1
		else
			back_track = 0;
	}
	else
	{
		if(back_track == _tn)
			return(0);
		else
			back_track = _tn;
	}
	
	var _track = back_tracks[back_track]
	var _back_ratio = audio_sound_get_track_position(back_music)/audio_sound_length(back_music);
	audio_stop_sound(back_music);
	back_music = audio_play_sound(_track,2,true,0);
	
	audio_sound_set_track_position(back_music,_back_ratio*audio_sound_length(back_music));
	audio_sound_gain(back_music,1,50)
}

increase_editor_type = function(){
	editor_type += 1
	if(editor_type >= array_length(editor_types))
	{
		editor_type = 0;
		editor_group += 1;
		editor_point_number = 0;
	}
	
}

load_map_button = function(){
	map_string = get_string_async("Map string:",clipboard_get_text());
}

edit_map_button = function(){
	room_goto(rm_editor);
}

finish_edit_button = function(){
	with obj_point
	{
		var _point = new obj_control.point(x,y,wait*60);
		with instance_find(obj_person, group)
			array_insert(path, 0, _point);
		instance_destroy();
	}
		
	var _p = [];
	with obj_person
	{
		array_push(_p,{"x":x,"y":y,"p":path})
	}
	show_debug_message(json_stringify(_p))
	var _str = "Map data coppied to clipboard";
	if(os_browser != browser_not_a_browser)
		_str += "Copy this:\n"+json_stringify(_p);
	show_message(_str);
	clipboard_set_text(json_stringify(_p));
	room_goto(Room1);
	//load_map(_p);
}

load_map = function(_map_string){
	try
	{
		if( is_string(_map_string))
			_map_string = json_parse(_map_string)
			
		menu_hide();
		if(map_surface)
			surface_free(map_surface);
		if(map_sprite)
			sprite_delete(map_sprite);
		map_surface = noone;
		map_sprite = noone;
		rift_available = true;
		
		with(obj_entity)
			instance_destroy();
		for(var i = 0; i < array_length(_map_string); i++)
		{
			var _p = _map_string[i];
			var _person = instance_create_layer(_p.x,_p.y,"Instances",obj_person);
			_person.path = _p.p;
			_person.direction = point_direction(_person.x,_person.y,_p.p[0].x,_p.p[0].y);
			if(point_distance(_person.x,_person.y,_p.p[0].x,_p.p[0].y) < 16)
			{
				_person.x = _p.p[0].x;
				_person.y = _p.p[0].y;
			}
		}
	}
	catch(_exception)
	{
		show_message("There was a problem while loading the map")
	}
}

point = function(_x,_y,_wait) constructor{
	x = _x;
	y = _y;
	wait = _wait;
}

smallest_person_distance = function(){
	var _dist = room_width;
	
	with obj_person
	{
		if(happy)
			continue
		for(var i = 0; i < instance_number(obj_person); i++)
		{
			var _p = instance_find(obj_person,i);
			if(_p == id or _p.happy)
				continue
			var _d = point_distance(x,y,_p.x,_p.y);
			if(_d < _dist)
				_dist = _d;
		}
	}
	
	return(_dist)
}

end_game_state = function(){
	var _stationary = true;
	var _happy = true;
	
	with(obj_person)
	{
		if(not sad and not happy)
			_stationary = false;
		if(not happy)
			_happy = false
	}
	
	return(_happy * 2 - _stationary)
}

breathe_offset_formula = function(_breathe, _breathe_frequency = 20, _offset = 1){
	var _breathe_offset = _offset*abs(sin(_breathe/_breathe_frequency));
	return _breathe_offset
}

//point = {
//	x: 0,
//	y: 0,
//	wait: 0
//}