/// @description Wstaw opis w tym miejscu
// W tym edytorze możesz zapisać swój kod

with(obj_person)
	if(happy and (breathe mod 30) == 0)
		part_particles_create(obj_control.part_system,x,y-6,obj_control.part_heart,1)

if(not point_in_rectangle(mouse_x,mouse_y,room_width*1/4,room_height*1/6,room_width*3/4,room_height*3/6) and mouse_check_button_pressed(mb_left))
{
	menu_alert = "";
	if(game_over)
	{
		with obj_entity
			instance_destroy();
		
		menu_hide();
		menu_buttons();
		game_over = false;
		game_speed = 0;
		if(map_surface)
			surface_free(map_surface)
		map_surface = noone
		game_set_speed(game_speeds[0], gamespeed_fps);
	}
}

if(not game_over and not instance_exists(obj_button))
{
	var _state = end_game_state();
	if(_state != 0)
	{
		game_over = true;
		menu_anim = 0.01;
		if(_state)
			menu_alert = "Victory";
		else
			menu_alert = "Defeat";
		show_debug_message("Game Over: "+string(_state));
	}
}

if(not mouse_check_button(mb_left))
{
	var _dist = smallest_person_distance();

	if(_dist < 80)
		increase_music_speed(2);
	else if(_dist < 160)
		increase_music_speed(1);
	else
		increase_music_speed(0);
}

if(keyboard_check_pressed(ord("E")))
{
	if(room == rm_editor)
	{
		finish_edit_button();
	}
	else
	{
		edit_map_button();
		//room_goto(rm_editor);
	}
}

if(keyboard_check_pressed(ord("G")))
{
	menu_alert = "TEST";
	menu_anim = 0.01;
}

if(keyboard_check_pressed(ord("L")))
{
	
	load_map_button()
	//map_string = get_string_async("Map string:","");
	
	//room_goto(rm_load);
	
}

if(keyboard_check_pressed(ord("M")))
	increase_music_speed();

if(mouse_check_button_pressed(mb_left))
{
	mouse_clicked_x = mouse_x;
	mouse_clicked_y = mouse_y;
}

if(rift_available and room != rm_editor and (not point_in_rectangle(mouse_x,mouse_y,room_width-32,8,room_width-32+16,8+16)) and menu_anim <= 0)
{
	if( mouse_check_button(mb_left))
	{
		var _speed_change = 1;
		if(mouse_y > mouse_clicked_y + rift_start_radius )
		{
			increase_music_speed(0)
			_speed_change = 0.8;
		}
		else if(mouse_y < mouse_clicked_y - rift_start_radius )
		{
			increase_music_speed(2)
			_speed_change = 1.25;
		}
		else
			increase_music_speed(1)
		with obj_entity
		{
			if point_in_circle(x,y,other.mouse_clicked_x, other.mouse_clicked_y, other.rift_radius)
				time_speed *= _speed_change;
		}
	}
	if(mouse_check_button_released(mb_left))
		rift_available = false;
}

if(room == rm_editor)
{
	if(not editor_move and mouse_check_button_pressed(mb_left))
	{
		var _e = instance_position(mouse_x,mouse_y,obj_entity);
		if(_e)
			editor_move = _e;
		//else
		//	editor_move = noone;
	}
	if(mouse_check_button(mb_left) and editor_move)
	{
		editor_move.x = mouse_x;
		editor_move.y = mouse_y;
	}
	if(mouse_check_button_released(mb_left) and editor_move)
	{
		editor_move = noone;	
	}
	
	if(mouse_check_button_pressed(mb_left) and not editor_move and menu_anim <= 0)
	{
		var _obj = editor_types[editor_type];
		if((mouse_x > 40 or mouse_y > 32) and place_empty(mouse_x,mouse_y,obj_entity))
		{
			var _instance = instance_create_layer(mouse_x, mouse_y, "Instances", _obj);
			if(editor_type == 1)
			{
				_instance.number = editor_point_number;
				_instance.wait = editor_wait;
				_instance.group = editor_group;
				editor_point_number += 1;
			}
			else
			{
				_instance.group = editor_group;
				editor_type += 1;	
			}
		}
		if(point_in_rectangle(mouse_x,mouse_y,8,24,8+8,24+8))
			editor_wait -= 1;
		if(point_in_rectangle(mouse_x,mouse_y,32,24,32+8,24+8))
			editor_wait += 1;
		if(point_in_rectangle(mouse_x,mouse_y,2,2,2+16,2+16))
			increase_editor_type();
	
		if(editor_wait < 0)
			editor_wait = 0;
	}
}
else
{
	if (irandom(60*1) == 0 and instance_exists(obj_person))
	{
		var _e;
		switch(irandom(2))
		{
			
			case 0:
				_e = instance_create_layer(irandom(1)*room_width,irandom(room_height),"Instances",obj_cloud);
				_e.move_speed *= (8+irandom(4))/10
			break;
			case 1:
				var _x = irandom(room_width);
				var _y = irandom(1)*room_height;
				var _s = (8+irandom(4))/10;
				_e = instance_create_layer(_x, _y+sign(_y-1)*(-8), "Instances", obj_bird);
				_e.move_speed *= _s;
				_e = instance_create_layer(_x-7+irandom(2), _y+irandom(2)*sign(_y-1), "Instances", obj_bird);
				_e.move_speed *= _s;
				_e = instance_create_layer(_x+7-irandom(2), _y+irandom(2)*sign(_y-1), "Instances", obj_bird);
				_e.move_speed *= _s;
			break;
			
			case 2:
			
			break;
		}
	}
}