var a = argument0;

switch (a)
{
	case ty.hero:
	{
		// shield bash
		var buff = 20;
		var angle = point_direction(x,y,mouse_x, mouse_y);
		var rad_a = degtorad(angle);

		with (instance_create_layer(x + (cos(rad_a)*buff),y - (sin(rad_a)*buff),"Effect",obj_hitbox))
		{
			owner = other.id;
			sprite_index = spr_shield_bash;
			image_angle = angle;
		}
		
		cur_spc_cool = type_to_spec_cool(a);
		break;
	}
	case ty.knight:
	{
		var buff = 10;
		var angle = point_direction(x,y,mouse_x, mouse_y);
		var rad_a = degtorad(angle);
		
		with (instance_create_layer(x + (cos(rad_a)*buff),y - (sin(rad_a)*buff),"Effect",obj_hitbox))
		{
			owner = other.id;
			sprite_index = spr_spear_throw;
			image_angle = angle;
			hsp = cos(rad_a) * 6;
			vsp = -sin(rad_a) * 6;
			lasting = true;
		}
		
		cur_spc_cool = type_to_spec_cool(a);
		break;
	}
	case ty.cleric:
	{
		curhp = approach(curhp, hp, 10);
		
		cur_spc_cool = type_to_spec_cool(a);
		state = st.stun;
		stun_cool = 20;
		
		break;
	}
	// dash
	case ty.rogue:
	{
		state = st.stun;
		
		var angle = point_direction(x,y,mouse_x, mouse_y);
		var rad_a = degtorad(angle);
		
		hsp = cos(rad_a) * 7;
		vsp = -sin(rad_a) * 7; 
		
		stun_cool = 10;
		cur_spc_cool = type_to_spec_cool(a);
		break;
	}
	// multi shot
	case ty.ranger:
	{
		state = st.stun;
		
		var buff = 10; 
		var angle = point_direction(x,y,mouse_x, mouse_y);
		var rad_a = degtorad(angle);
		
		hsp = 0;
		vsp = 0;
		
		stun_cool = 30;
		for (var ii = -2; ii < 2; ii++)
		{
			with (instance_create_layer(x + (cos(rad_a)*buff),y - (sin(rad_a)*buff),"Effect",obj_hitbox))
			{
				var n_a = angle + (15 * ii);
				var n_ra = degtorad(n_a);
				owner = other.id;
				sprite_index = type_to_sprite(a);
				image_angle = n_a;
				lasting = type_to_last(a);
				hsp = cos(n_ra) * 15;
				vsp = -sin(n_ra) * 15;
			}
		}
		
		cur_spc_cool = type_to_spec_cool(a); 
		break;
	}
	// whirlwind
	case ty.paladin:
	{
		state = st.stun;
		
		hsp = 0;
		vsp = 0;
		
		stun_cool = 1000;
		with (instance_create_layer(x,y,"Effect",obj_hitbox))
		{
			owner = other.id;
			sprite_index = spr_whirlwind;
		}
		
		cur_spc_cool = type_to_spec_cool(a);
		
		break;	
	}
}