//
// Simple passthrough fragment shader
//
varying vec2 v_vTexcoord;
varying vec4 v_vColour;

uniform float pixelH;
uniform float pixelW;

uniform float inv;

void main()
{
	vec4 Color = texture2D( gm_BaseTexture, v_vTexcoord );
	
	
	vec2 offsetx; // vector with x and y component
	offsetx.x = pixelW; // getting width and height of pixel based on texture page. based on "Textel"
	vec2 offsety;
	offsety.y = pixelH;
	
	
	float red = Color.r;
	float blue = Color.b;
	float green = Color.g;
	
	// v giving our current pixel, return its alpha
	float alpha = texture2D( gm_BaseTexture, v_vTexcoord ).a;
	float prev_alpha = alpha;
	if (inv == 1.0)
	{
	// add alpha of pixels around it
		alpha += ceil(texture2D(gm_BaseTexture, v_vTexcoord + offsetx).a);
		alpha += ceil(texture2D(gm_BaseTexture, v_vTexcoord - offsetx).a);
		alpha += ceil(texture2D(gm_BaseTexture, v_vTexcoord + offsety).a);
		alpha += ceil(texture2D(gm_BaseTexture, v_vTexcoord - offsety).a);
	}
	
	if ((red > 0.674 && red < 0.675) && (green > 0.196 && green < 0.197) && (blue > 0.196 && blue < 0.197))
	{
		red = 0.0 / 255.0;
		blue = 255.0 / 255.0;
		green = 255.0 / 255.0;
	}	
	
    gl_FragColor = vec4(red, green, blue, Color.a);
	if (prev_alpha == 0.0) gl_FragColor.rgb = vec3(1.0);
}
