
var view_x_offset = camera_get_view_x(view_camera[0]);
var view_y_offset = camera_get_view_y(view_camera[0]);
var view_width = camera_get_view_width(view_camera[0]);
var view_height = camera_get_view_height(view_camera[0]);

// Draw the menu background on the bottom of the view

draw_sprite_ext(sMenuBG, 0,
	view_x_offset, // x
	view_y_offset + (view_height - sprite_get_height(sMenuBG)), // y
	view_width / sprite_get_width(sMenuBG), // xscale
	1, // yscale
	0, -1, 1);

// Draw menu items & their backgrounds

var ypos = view_y_offset + view_height - (sprite_get_height(sMenuBG) * .6);
var xpos = view_x_offset + (sprite_get_width(sMenuCard) * .5) + (xbetween / 2) - (scroll * (sprite_get_width(sMenuCard) + xbetween));
var xchange = sprite_get_width(sMenuCard) + (xbetween / 2);

for (var card = 0; card < array_length(buildings); card++) {
	draw_sprite(sMenuCard, 0, xpos + (card * xchange), ypos);
	
	draw_sprite(buildings[card].icon, 0, xpos + (card * xchange), ypos + 5);
	
	draw_set_font(SmallFont);
	draw_set_halign(fa_center);
	draw_set_valign(fa_middle);
	draw_text(xpos + (card * xchange), ypos + (sprite_get_width(buildings[card].icon) * .2) + (1.2 * sprite_get_height(sSmallMoney)), buildings[card].name);

	var cost_string = string(buildings[card].cost);
	draw_sprite(sSmallMoney, 0, xpos + 6 + (card * xchange) - (.5 * string_width(cost_string)), ypos + (sprite_get_width(buildings[card].icon) * .5))

	draw_text(xpos + 5 + (card * xchange), ypos + (sprite_get_width(buildings[card].icon) * .5), cost_string);
}

if (window_mouse_get_y() / (view_hport[0] / view_height) >= (view_height - sprite_get_height(sMenuBG))) {
	var item = round((mouse_x - xpos) / xchange);
	draw_sprite_ext(sMenuCard, 1, xpos + (xchange * item), ypos, 1, 1, 0, -1, .3);
}

// Draw money & military points
var money_pos = new Vec2(3, 2);
var military_pos = new Vec2(2, money_pos.y * 2 + sprite_get_height(sMoney));

draw_set_font(BigFont);
draw_set_valign(fa_middle);
draw_set_halign(fa_left);

draw_sprite(sMoney, 0, view_x_offset + money_pos.x, view_y_offset + money_pos.y);
draw_text(view_x_offset + money_pos.x * 2 + sprite_get_width(sMoney), view_y_offset + money_pos.y + (sprite_get_height(sMoney) / 2), string(floor(global.player.coins)));

draw_sprite(sMilitary, 0, view_x_offset + military_pos.x, view_y_offset + military_pos.y);
draw_text(view_x_offset + military_pos.x * 2 + sprite_get_width(sMoney), view_y_offset +  military_pos.y + (sprite_get_height(sMilitary) / 2), string(floor(global.player.weapons)));
