global.gameobj = self;

global.game_active = false;
instance_create_layer(0, 0, layer, oStart);

fullscreen_pressed = false;

// Create building types.
// Remember that they are referenced in oBuildingMenu.
global.buildingtypes = ds_map_create();

global.buildingtypes[? "Road"] = new BuildingType("Road", 1, 10, 0, sRoad, sRoadIcon, 0,
		function (cells) {
			for (var i = 0; i < array_length(cells[0].environment); i++)
			{
				if (cells[0].environment[i] == WATER)
					return false;
			}
			
			for (var cell = 0; cell < array_length(cells); cell++) {
				var current_cell = cells[cell];
				
				if (current_cell == noone)
					continue;
				
				if !is_struct(current_cell.building)
					continue;
					
				
				if is_struct(current_cell.building.type)
					return true;
			}
			
			return false;
		}, noone);

global.buildingtypes[? "Mine"] = new BuildingType("Mine", 7, 30, 5, sMine, sMineIcon, 0,
	function (cell) {
		cell = cell[0]
			
		if (cell == noone)
			return false;
			
		var valid_terrain = false;
			
		for (var i = 0; i < array_length(cell.environment); i++)
		{
			valid_terrain =
				valid_terrain || 
				(cell.environment[i] == ENERGY);
				
			if (cell.environment[i] == WATER)
				return false;
		}
			
		return valid_terrain;
	}, noone);
	
global.buildingtypes[? "HQ"] = new BuildingType("Parliament house", noone, noone, 0, sHQ, noone, 0, noone, noone);

global.buildingtypes[? "Barrack"] = new BuildingType("Barrack", 5, 60, 0, sMilitaryBase, sMilitaryBaseIcon, 1,
		function (cells) {
			var cell = cells[0];
		
			if (cell == noone)
				return false;
		
			var valid_terrain = false;
			
			for (var i = 0; i < array_length(cell.environment); i++)
			{
				valid_terrain =
					valid_terrain || 
					(cell.environment[i] == FOREST);
				
				if (cell.environment[i] == WATER)
					return false;
			}
		
			return valid_terrain;
		}
	, noone);

global.buildingtypes[? "Univ."] = new BuildingType("Univ.", 15, 60, 0, sSchool, sSchoolIcon, 0,
		function (cells) {
			var cell = cells[0];
			
			if (cell == noone)
				return false;
			
			for (var i = 0; i < array_length(cell.environment); i++)
			{
				if ((cell.environment[i] == WATER) || cell.environment[i] == FOREST)
					return false;
			}
		
			return true;
		},
	new BuildingType("Plant", 30, 60, 12, sNukeplant, sNukeplantIcon, 0,
		function (cells) {
			var cell = cells[0];
		
			if (cell == noone)
				return false;
			
			for (var i = 0; i < array_length(cell.environment); i++)
			{
				if ((cell.environment[i] == WATER) || cell.environment[i] == FOREST)
					return false;
			}
		
			return true;
		},
	new BuildingType("Nuke", 20, 120, 0, sNukelauncher, sNukelaucherIcon, 10,
		function (cells) {
			var cell = cells[0];
		
			if (cell == noone)
				return false;
			
			for (var i = 0; i < array_length(cell.environment); i++)
			{
				if ((cell.environment[i] == WATER) || cell.environment[i] == FOREST)
					return false;
			}
		
			return true;
		}
	, noone)));

global.player = new Player();
global.computer = new Player();
global.computer.type = COMPUTER;
global.computer.color = c_blue;

mapobj = instance_create_layer(0, 0, "Map", oMap);
mapobj.gameobj = self;

buildmenuobj = instance_create_layer(0, 0, "Menus", oBuildingMenu);
buildmenuobj.gameobj = self;

camera = instance_create_layer(0, 0, layer, oCamera);


alarm_set(0, 908275 * (1 / 1000) * fps);
has_nukes = false;
alarm_set(1, fps * 10);
