function Map(_w, _h) constructor {
	w = _w;
	h = _h;
	
	map = [];
	
	for(var i = 0; i < w * h; i++) {
		map[i] = new Map_cell([WATER]);
	}
	
	static get = function (_x, _y) {
		if ((_x < w) && (_y < h) && (_x >= 0) && (_y >= 0))
			return map[ (_y * w) + _x ];
		return noone;
	}
	
	static draw = function () {
		for(var _y = 0; _y < h; _y++) {
			for(var _x = 0; _x < w; _x++) {
				var _cell = get(_x, _y);
				
				var pos_on_screen = map_to_screen(new Vec2(_x, _y));
				
				var chosen = false;
				if (vec_equals(screen_to_map(new Vec2(mouse_x, mouse_y)), new Vec2(_x, _y)))
					chosen = true;
				
				_cell.draw(pos_on_screen.x, pos_on_screen.y, chosen);
			}
		}
	}
	
	static set_environment_from_list = function(_list) {
		for(var _y = 0; _y < h; _y++) {
			for(var _x = 0; _x < w; _x++) {
				var cell = get(_x, _y);
				
				cell.environment = [_list[ (_y * w) + _x ]];
			}
		}
	}
	
	static add_to_environment_from_list = function(_list) {
		for(var _y = 0; _y < h; _y++) {
			for(var _x = 0; _x < w; _x++) {
				var cell = get(_x, _y);
				
				var to_add = _list[ (_y * w) + _x ];
				
				if !(to_add == -1)
					array_push(cell.environment, _list[ (_y * w) + _x ]);
			}
		}
	}
	
	static create_building = function(_x, _y, _type, _owner) {
		var tile = get(_x, _y);
		
		// "Enemy creation"
		//show_debug_message("[" + string(current_time) + ", \"" + string(_type.name) + "\", " + string(_x) + ", " + string(_y) + "]");
		
		if !is_struct(tile)
			return false;
		
		if is_struct(tile.building)
			return false;
		
		if (
			_type.positionvalidation([
				get(_x, _y),
				get(_x - 1, _y),
				get(_x + 1, _y),
				get(_x, _y + 1),
				get(_x, _y - 1)
			]) && (get(_x, _y))
		)
		{
			get(_x, _y).building = new Building(_type);
			if (_type == global.buildingtypes[? "Road"])
				own(_x, _y, _owner);
			autotile_building(_x, _y, true);
			return true;
		}
		return false;
	}
	
	static create_building_forced = function(_x, _y, _type) {
		get(_x, _y).building = new Building(_type);
	}
	
	static own = function(_x, _y, owner) {
		for (var i = _x - 1; i <= _x + 1; i++) {
			for (var j = _y - 1; j <= _y + 1; j++) {
				var cell = get(i, j);
				
				if (cell == noone)
					continue;
				
				cell.owner = owner;
			}
		}
	}
	
	static autotile_building = function(_x, _y, _update) {
		#macro LEFT 0
		#macro RIGHT 1
		#macro UP 2
		#macro DOWN 3
		
		var this_cell = get(_x, _y);
		var this_building = this_cell.building;
		
		var adjancent_buildings = [];
		
		adjancent_buildings[LEFT] = get(_x - 1, _y);
		adjancent_buildings[RIGHT] = get(_x + 1, _y);
		adjancent_buildings[UP] = get(_x, _y - 1);
		adjancent_buildings[DOWN] = get(_x, _y + 1);
		
		for (var b = 0; b < 4; b++) {
			if (is_struct(adjancent_buildings[b]) &&
				is_struct(adjancent_buildings[b].building))
			{
				adjancent_buildings[b] = true;
				if (_update)
					autotile_building(_x - (b == LEFT) + (b == RIGHT), _y + (b == DOWN) - (b == UP), false);
			} else {
				adjancent_buildings[b] = false;
			}
		}
		
		// Check if *this* building is to be tiled. The loop is above this because the adjancent buildings may be tileable.
		
		var tileable_buildings = [global.buildingtypes[? "Road"]];
		var is_tileable_building = false;
		
		for (var i = 0; i < array_length(tileable_buildings); i++)
			is_tileable_building = is_tileable_building || (this_building.type == tileable_buildings[i]);
		
		if !is_tileable_building
			return false;
		
		
		var l = adjancent_buildings[LEFT];
		var r = adjancent_buildings[RIGHT];
		var u = adjancent_buildings[UP];
		var d = adjancent_buildings[DOWN];
		
		var tile =
			 0 * (!l && !r && !u && !d) +
			 1 * (!l && !r && !u &&  d) +
			 2 * (!l && !r &&  u && !d) +
			 3 * ( l && !r && !u && !d) +
			 4 * (!l &&  r && !u && !d) +
			 5 * (!l && !r &&  u &&  d) +
			 6 * ( l &&  r && !u && !d) +
			 7 * ( l && !r && !u &&  d) +
			 8 * (!l &&  r && !u &&  d) +
			 9 * (!l &&  r &&  u && !d) +
			10 * ( l && !r &&  u && !d) +
			11 * ( l &&  r &&  u && !d) +
			12 * (!l &&  r &&  u &&  d) +
			13 * ( l &&  r && !u &&  d) +
			14 * ( l && !r &&  u &&  d) +
			15 * ( l &&  r &&  u &&  d);
		
		this_building.tile = tile;
	}
	
}

function Map_cell(_environment) constructor {
	environment = _environment;
	
	owner = undefined;
	
	building = undefined;
	
	static draw = function (_x, _y, _chosen) {
		for (var i = 0; i < array_length(environment); i++) {
			var _s = global.map_sprites[environment[i]];
			
			draw_sprite_ext(_s, 0, _x, _y, 1, 1, 0, -1, 1);
		}
		
		draw_sprite_ext(sTile, !_chosen, _x, _y, 1, 1, 0, -1, .1);
		
		if (owner != undefined) {
			draw_sprite_ext(sTile, 0, _x, _y, 1, 1, 0, owner.color, .2);
		}
		
		if (building != undefined) {
			building.draw(_x, _y);
		}
	}
}

function map_to_screen(pos) {
	return new Vec2((pos.x - pos.y) * (TILE_W * .5), (pos.x + pos.y) * (TILE_H / 2));
}

function screen_to_map(pos) {
	return new Vec2(
		round((pos.x / TILE_W) + (pos.y / TILE_H)),
		round((pos.y / TILE_H) - (pos.x / TILE_W))
	);
}
