var gone_minutes = (((current_time - last_update) / 1000) / 60);
last_update = current_time;

if (global.game_active) {
	for (var _x = 0; _x < map.w; _x++) {
		for (var _y = 0; _y < map.h; _y++) {
			var tile = map.get(_x, _y);
		
			// Guard clauses
		
			if !is_struct(tile.building)
				continue;
		
			if !is_struct(tile.owner)
				continue;
		
			var building = tile.building;
		
			if ((current_time / 1000) - building.creation_time < building.type.buildtime)
				continue;
		
			// Building ready!
		
			var owner = tile.owner;
		
			var lootpos = map_to_screen(new Vec2(_x + random(1) - .5, _y + random(1) - .5));
		
			// Get the money
				
		
			if ((owner == global.player) && (random(1) < .01) && (building.type.coinsperminute > 0))
				instance_create_layer(lootpos.x, lootpos.y, "Coins", oCoin);
		
			owner.coins += building.type.coinsperminute * gone_minutes;
		
			// Get the weapon points
		
			if ((owner == global.player) && (random(1) < .01) && (building.type.weaponperminute > 0))
				instance_create_layer(lootpos.x, lootpos.y, "Coins", oWeapon);
		
			owner.weapons += building.type.weaponperminute * gone_minutes;
		}
	}
}

alarm_set(0, 15);
