function Building(_type) constructor {
	type = _type;
	
	creation_time = current_time / 1000;
	
	tile = noone;
	
	static draw = function (_x, _y, _w, _h) {
		if is_struct(type.makesavailable) {
			var is_available = is_struct(global.buildingtypes[? type.makesavailable.name]);
		
			if (!is_available && ((current_time / 1000) - creation_time > type.buildtime)) {
				global.buildingtypes[? type.makesavailable.name] = type.makesavailable;
			
				array_push(global.gameobj.buildmenuobj.buildings, type.makesavailable);
				
				type.makesavailable = noone;
			}
		}
		
		var sprite = type.sprite;

		var _progress = min(((current_time / 1000) - creation_time) / type.buildtime, 1);
		
		var subimage = tile;
		if (tile == noone)
			var subimage = round((sprite_get_number(sprite) - 1) * _progress);
		
		draw_sprite_ext(sprite, subimage, _x, _y, 1, 1, 0, -1, 1);
	}
}

function BuildingType(_name, _cost, _buildtime, _coinsperminute, _mapsprite, _icon, _weaponperminute, _positionvalidation, _makesavailable) constructor {
	name = _name;
	cost = _cost;
	buildtime = _buildtime;
	coinsperminute = _coinsperminute;
	weaponperminute = _weaponperminute;
	sprite = _mapsprite;
	icon = _icon;
	positionvalidation = _positionvalidation;
	makesavailable = _makesavailable;
}
