//
// Simple passthrough fragment shader
//
varying vec2 v_vTexcoord;
varying vec4 v_vColour;
uniform float pix_width;
uniform float pix_height;

void main()
{
	vec2 xoffset;
	xoffset.x = pix_width;
	vec2 yoffset;
	yoffset.y = pix_height;
	
	gl_FragColor = v_vColour * texture2D( gm_BaseTexture, v_vTexcoord );
    float alpha = gl_FragColor.a;
	
	alpha += ceil(texture2D(gm_BaseTexture, v_vTexcoord + xoffset).a);
	alpha += ceil(texture2D(gm_BaseTexture, v_vTexcoord - xoffset).a);
	alpha += ceil(texture2D(gm_BaseTexture, v_vTexcoord + yoffset).a);
	alpha += ceil(texture2D(gm_BaseTexture, v_vTexcoord - yoffset).a);
	
	gl_FragColor.a = alpha;
}
