/// @desc	Level UI
with sys_level {
 var __countdown = countdown_current/countdown;
 //Player guidance
 if state <= ls.prepare with par_enemy {
  draw_set_color(c_red);
  draw_set_alpha((sin(current_time/1000)+3)/4);
  draw_circle(x,y,sprite_height/2+10,true);
  draw_set_alpha(1);
 }
 if state == ls.prepare with obj_player {
  gpu_set_blendmode_ext(bm_inv_dest_colour, bm_zero);
  gpu_set_texfilter(1);
  
  var __dir = point_direction(x,y,mouse_x,mouse_y);
  var __len = point_distance(x,y,mouse_x,mouse_y);
  var __x = x+image_xscale*5+lengthdir_x(12,__dir)+lengthdir_x(1,__dir+((image_xscale >= 1) ? 90 : -90));
  var __y = y+lengthdir_y(12,__dir)+lengthdir_y(1,__dir+((image_xscale >= 1) ? 90 : -90));
  
  for(var i=1;i<floor(__len/8);i++) {
   //Test for collision
   var __x, __y;
   for(var j=1;j<9;j++){
    __x = x+lengthdir_x((i)*8+j,__dir);
    __y = y+lengthdir_y((i)*8+j,__dir);
    if position_meeting(__x,__y,par_can_be_hit) {
     break;
    }
   }
   if j < 9 {
    break;
   }
   //Draw part of the line
   draw_sprite_ext(spr_aim_line,0,__x,__y,1,1,__dir,c_white,.5);
  }
  
  gpu_set_texfilter(0);
  gpu_set_blendmode(bm_normal);
 }
 
 //Black Bars
 draw_set_color(c_black);
 draw_rectangle(0,0,room_width-1,lerp(64,16,__countdown),false);
 draw_rectangle(0,room_height-1,room_width-1,lerp(room_height-65,room_height-25,__countdown),false);
 
 //Timer
 draw_set_color(c_black);
 draw_rectangle(0,room_height-25,room_width-1,room_height-1,false);
 draw_set_color(merge_color(c_red,c_yellow,__countdown));
 draw_roundrect(2,room_height-21,2+(room_width-5)*(__countdown),room_height-5,false);
 
 //Score
 var __str = "Score: "+string(score);
 if score_addition > 0 {
  __str += " + "+string(score_addition);
 }
 draw_set_font(fnt_medium_text);
 draw_set_halign(fa_left);
 draw_set_valign(fa_top);
 draw_set_color(c_white);
 draw_text(4,4,__str);
 
 with obj_tumbleweed {
  draw_self();
 }
 
 //Fade in
 if fade_in > 0 {
  draw_set_color(c_black);
  draw_set_alpha(fade_in);
  draw_rectangle(0,0,room_width-1,room_height-1,0);
  draw_set_alpha(1);
 }
}