/// @description Initialize Blood Surface

//Create Layer for Rendering
global.bloodLayer = layer_create(8000);

//Particle System
partBlood_sys = part_system_create();
part_system_depth(partBlood_sys, -1);

//Blood Particle
partBlood = part_type_create();
part_type_shape(partBlood, pt_shape_square);
part_type_size(partBlood, 0.2, 0.1, -0.01, 0);
part_type_color1(partBlood, 255);
part_type_alpha1(partBlood, 1);
part_type_speed(partBlood, 1, 2, 0, 0);
part_type_direction(partBlood, 0, 359, 0, 0);
part_type_gravity(partBlood, 0.1, 270);
part_type_blend(partBlood, 0);
part_type_life(partBlood, 20, 100);

//Create Emitter
partBlood_emit = part_emitter_create(partBlood_sys);

//Create Surface
surfBlood = surface_create(room_width, room_height);

scr_blood_effect();
