/// @description Player Controller

//Find Mouse Pos & Calculate for Camera
var mX = mouse_x;
var mY = mouse_y;
camToXHalf = round((x + mX)/2);
camToYHalf = round((y + mY)/2);
camToX = round((x + camToXHalf)/2);
camToY = round((y + camToYHalf)/2);

if (isMoving){
	//Face Mouse
	if (!global.gameOver){
		targetAngle = point_direction(x, y, mouse_x, mouse_y);
		angleDiff = angle_difference(image_angle, targetAngle);
		image_angle -= (min(abs(angleDiff), 10) * sign (angleDiff)) * turnMod;	
	}

	direction = image_angle;

	//Set Speed With Boost
	speed = moveSpeed * boostMod;

	//Boost Wish Mouse Buttons
	if (!global.gameOver){
		if (mouse_check_button(mb_left)){
			if (boostMod < maxBoost){
				boostMod += boostInc;	
			}
			obj_cameraController.smallShake = true;
			turnMod = .75;
			repeat(3){
				instance_create_layer(x-random_range(-6, 6), y+random_range(-6, 6), "Instances", obj_player_movePart);	
			}
			instance_create_layer(x-random_range(-6, 6), y+random_range(-6, 6), "Instances", obj_player_boostPart);
		} else if (mouse_check_button(mb_right)){
			if (boostMod > minBoost){
				boostMod -= boostInc;	
			}
			obj_cameraController.smallShake = false;
			turnMod = 1.45;
		} else {
			if (boostMod < 1){
				boostMod += boostInc;	
			}
			if (boostMod > 1){
				boostMod -= boostInc;	
			}
			obj_cameraController.smallShake = false;
			turnMod = 1;	
		}
	}
	//Create Smoke Trail Effect
	instance_create_layer(x-random_range(-5, 5), y+random_range(-5, 5), "Instances", obj_player_movePart);
	
}