key_left = keyboard_check(vk_left);
key_right = keyboard_check(vk_right);

key_up = keyboard_check(vk_up);
key_down = keyboard_check(vk_down);

key_space = keyboard_check_pressed(vk_space);
var force_stop_record = false;

visible = 0;

if !obj_game_manager.SHOWING_TRANS {
	var moveX = key_right - key_left;
	var moveY = key_down - key_up;

	var step = obj_game_manager.TIMELINE_STEP;
	var mana_lost = 0;

	// calculate the mana status
	if recording {
		mana_lost += obj_game_manager.MANA_STEP_COST;
	} else if key_space {
		mana_lost += obj_game_manager.MANA_SPAWN_COST;
	}

	if mana_lost >= MANA {
		message = "not enough mana";
		mana_lost = 0;
		MANA = 0;
		
		if recording {
			force_stop_record = true;
			recording = false;
		}
	}
 
 
	// stop record if it's a different player
	if recording && obj_game_manager.ACTIVE_PLAYER != player {
		force_stop_record = true;
	}

	if key_space && !recording {
		STEP_RECORD = step;
	}

	if (key_space && recording) || force_stop_record {
		var replication = instance_create_layer(x, y, "Instances", clone);
		replication.INITIAL_STEP = STEP_RECORD;
		x_pos = [];
		y_pos = [];
		force_stop_record = false;
	}

	MANA -= mana_lost;

	if obj_game_manager.ACTIVE_PLAYER == player {
		visible = 1;
		if (key_space) {
			recording = !recording; 
		}

		hsp = moveX * walks;
		vsp = moveY * walks;
	
		if hsp != 0 || vsp != 0 {
			obj_game_manager.PAUSED = false;
		}

		x = x + hsp;
		y = y + vsp;

		x_pos[step] = x;
		y_pos[step] = y;
		if recording && MANA > 0 && step % 10 == 0 {
			scr_place_track(x, y, track);
		}

	} else {
		x = initialPosX;
		y = initialPosY;
		imageIndex = 2;
		recording = false;
		message = "";
		MANA = MANA_AMOUNT;
	}
	
	if key_right {
		image_index = 0;
	} else if key_left {
		image_index = 1;
	} else if key_up {
		image_index = 3;
	} else if key_down {
		image_index = 2;
	}

	x = clamp(x, 0, room_width);
	y = clamp(y, 0, room_height);
}
