///@description hit_object
///@param object
///@param damage
var OBJ = argument0;
var DMG = argument1;
with (OBJ)
{
	if (object_type == ot_enemy)
	{
		if (activate == true)
		{
			hit = true; //flash
			hp -= DMG;
			alarm[11] = 20;
			if (object_type2 == "boss")
			{
				var SND = audio_play_sound(snd_ouch, 0, false);
				audio_sound_pitch(SND, 0.475+random(0.5));
			}
			//stop flashing in X steps
			//playsound
			if (hp <= 0)
			{
				var DIE = instance_create_layer(x, y, layer_get_name("Walls"), obj_die);
				DIE.sprite_index = die_sprite;
				if !audio_is_playing(snd_ghost_die) // we don't want 100 of these playing
				{
					audio_play_sound(snd_ghost_die, 1, false);
				}
				//don't destroy spawners, we want to revive them if you die
				if (object_type2 == "spawn")
				{
					hp = 0;
					activate = false;
					visible = false;
					if (loot_count > 0 and died_before == false)
					{
						died_before = true;
						repeat(loot_count)
						{
							instance_create_layer(x-1+irandom(2), y-1+irandom(2), layer, obj_coin);
						}
					}
				}
				else if (object_type2 == "boss")
				{
					instance_create_layer(0, 0, layer_get_name("UI2"), obj_the_end); //beat the game
					instance_destroy();
				}
				else
				{
					instance_destroy();
				}
			}
		}
	}
	else if (object_type == ot_wall)
	{
		if (strength >= 0)
		{
			if (strength == 0 or other.pwr[pwr_power] == true)
			{
				if (strength == 0)
				{
					image_index += (1+other.pwr[pwr_power]);
				}
				else
				{
					image_index += 1;
				}
				if (image_index >= sprite_get_number(sprite_index))
				{
					instance_destroy();
				}
			}
			else
			{
				return false;
			}
		}
	}
	else if (object_type == ot_boulder)
	{
		if (strength >= 0)
		{
			image_index += 1;
			if (image_index >= sprite_get_number(sprite_index))
			{
				instance_destroy();
			}
		}
		//push boulder forward
		else
		{
			image_index += 1;
			var ANG = round(obj_char.angle / 90) * 90;
			show_debug_message("ANGLE = " + string(ANG));
			var DIS = 8;
			if (!place_meeting(x+lengthdir_x(DIS, ANG), y+lengthdir_y(DIS, ANG), par_solid))
			{
				x += lengthdir_x(DIS, ANG);
				y += lengthdir_y(DIS, ANG);
			}
			//check for switches under and activate if applicable
			var SWITCH = instance_nearest(x, y, obj_switch);
			with (SWITCH)
			{
				if (point_distance(other.x, other.y, x, y) < 4)
				{
					image_index = 1;
					with (obj_wall_locked)
					{
						if (index == other.index)
						{
							instance_destroy();
						}
					}
				}
			}
		}
	}
	else if (object_type == ot_friend)
	{
		hit = true;
		hit_timing = timing;
		//heal 1 hp each time you hit a friendly ghost
		obj_char.hp = clamp(obj_char.hp+1, 0, obj_char.hpmax);
		if (activated == true)
		{
			if (coins > 0 or obj_char.debug)
			{
				coins -= 1;
				message3 -= 1;
				var TEXT = instance_create_layer(x, y, layer_get_name("UI2"), obj_text);
				TEXT.text = "+1";
				var TEXT = instance_create_layer(camera_get_view_x(view_camera[0]+4), camera_get_view_y(view_camera[0]+120), layer_get_name("UI2"), obj_text);
				var SND = audio_play_sound(snd_coin, 0, false);
				audio_sound_pitch(SND, 0.7+random(0.2)); //random pitch
				TEXT.text = "-1";
				if (message3 <= 0)
				{
					var TEXT = instance_create_layer(x, y, layer_get_name("UI2"), obj_text2);
					if (pwr == pwr_range)
					{
						TEXT.text = "Pickaxe Range Increase!";
					}
					else if (pwr == pwr_power)
					{
						TEXT.text = "Pickaxe Power Increase!";
					}
					else if (pwr == pwr_shockwave)
					{
						TEXT.text = "Pickaxe Has Shockwave!";
					}
					else if (pwr == 4)
					{
						TEXT.text = "HP has increased!";
						obj_char.hp += 1;
						obj_char.hpmax += 1;
						message3 = 1;
						return true; //don't destroy ghost or give power
					}
					instance_destroy();
					other.pwr[pwr] = true;
					return true; //return now, so we don't ask for 0 coins.....
				}
			}
		}
		else
		{
			activated = true;
		}
		var TEXT = instance_create_layer(x, y, layer_get_name("UI2"), obj_text2);
		TEXT.text = message1 + string(message3) + message2;
	}
	else if (object_type == ot_checkpoint and hit == false)
	{
		//var TEXT = instance_create_layer(x, y, layer_get_name("UI2"), obj_text);
		//TEXT.text = "Checkpoint!";
		var TEXT = instance_create_layer(x, y, layer_get_name("UI2"), obj_text2);
		TEXT.text = "Checkpoint!";
		//create new checkpoint
		obj_char.checkpointx = x;
		obj_char.checkpointy = y;
		hit = true;
		hit_timing = timing;
	}
}

return true;