/// @description Step
#region basic happenings
timing += 1;

if (freeze == true)
{
	if (dead == true)
	{
		if (timing >= time_dead+90)
		{
			dead = false;
			freeze = false;
			x = checkpointx;
			y = checkpointy;
			if (x < 80 and y < 80) {with (obj_UI) {start = 1;}}
			hp = hpmax;
			hit = true;
			hit_timing = timing;
			alarm[11] = 60;
			sprite_index = spr_char;
			//snap camera
			camera_set_view_pos(view_camera[0], clamp(x-80,0,room_width-160), clamp(y-60,0,room_height-120));
			//fix enemies
			with (par_monster)
			{
				if (object_type2 != "normal")
				{
					//revive and deactivate all spawners if you die
					visible = true;
					activate = false;
					hp = hpmax;
					//for boss specifically
					if (object_type2 == "boss")
					{
						pickaxe_out = false;
						x = xstart;
						y = ystart;
						speed = 0;
						direction = 90;
						angle = 90;
					}
				}
				else
				{
					instance_destroy();
				}
			}
			with (obj_wall_arrow)
			{
				activate = false;
			}
			with (obj_arrow)
			{
				instance_destroy();
			}
		}
	}
	exit;
}

if pickaxe_out > 0
{
	animate_speed = 0.25;
}
else
{
	animate_speed = 0.2;
}

//flash every other step if hit
if (hit == true and floor(timing/2) mod 2 = 0)
{
	image_alpha = 0;
}
else
{
	image_alpha = 1;
}
//check if dying
if (hp <= 0)
{
	hp = 0;
	freeze = true;
	dead = true;
	time_dead = timing;
	sprite_index = spr_nil;
	instance_create_layer(x, y, layer_get_name("Chars_below"), obj_die);
}
//point towards mouse at all times (unless attacking)
if (pickaxe_out == 0)
{
	angle = point_direction(x, y, mouse_x, mouse_y);
}
#endregion
#region Get click tile location
mouse_tile_x = mouse_x div 8;
mouse_tile_y = mouse_y div 8;
//update pickaxe image index
pickaxe_img_index += pickaxe_img_speed;
/*var XX = x div 8; var YY = y div 8;
show_debug_message("char_tile_x = " + string(char_tile_x) + "  char_tile_y = " + string(char_tile_y))*/
#endregion
#region Controls/Movement/Attack
var R = max(keyboard_check(ord("D")), keyboard_check(vk_right));
var L = max(keyboard_check(ord("A")), keyboard_check(vk_left));
var U = max(keyboard_check(ord("W")), keyboard_check(vk_up));
var D = max(keyboard_check(ord("S")), keyboard_check(vk_down));
var movex = movespeed*(R-L);
var movey = movespeed*(D-U);
//check for click buffer
if (pickaxe_out > 0)
{
	if (mouse_check_button_pressed(mb_left) and pickaxe_img_index > sprite_get_number(pickaxe_sprite)/2)
	{
		attack_buffer = true;
	}
}
//if we've reached the correct frame, throw out attack/shockwave
if (pickaxe_out == 1 and pickaxe_img_index >= pickaxe_img_speed * 18)
{
	var HIT1 = false; var HIT2 = false; var HIT3 = false;
	var STR = 0;
	//base effect, attack/mine rocks
	if (pwr[pwr_range] == true)
	{
		var DIS = 13; var SIZE = 12;
	}
	else
	{
		var DIS = 10; var SIZE = 10;
	}
	var XX = x+lengthdir_x(DIS, angle) - (SIZE/2); var YY = y+lengthdir_y(DIS, angle) - (SIZE/2);
	//check for boulders first (prevents bugs)
	do
	{
		var COLL = collision_rectangle(XX, YY, XX+(SIZE*sign(XX)), YY+(SIZE*sign(YY)), par_boulder, false, true);
		if (COLL != noone)
		{
			scr_hit(COLL, pickaxe_damage+pwr[pwr_power]);
			instance_deactivate_object(COLL);
			HIT1 = true;
		}
	}
	until (COLL == noone);
	//now check for everything else
	do
	{
		var COLL = collision_rectangle(XX, YY, XX+(SIZE*sign(XX)), YY+(SIZE*sign(YY)), par_canhit, false, true);
		//var COLL = collision_line(x, y, x+lengthdir_x(DIS, angle), y+lengthdir_y(DIS, angle), par_canhit, true, true);
		if (COLL != noone)
		{
			var TYPE = COLL.object_type; //record now, in case dies
			if (TYPE == ot_wall)
			{
				var STR = COLL.strength;
			}
			var SUCCESS = scr_hit(COLL, pickaxe_damage+pwr[pwr_power]);
			if (TYPE == ot_wall)
			{
				if (STR < 0 or !SUCCESS)
				{
					HIT3 = true;
				}
				else
				{
					HIT1 = true;
				}
			}
			else if (TYPE == ot_enemy)
			{
				HIT2 = true;
			}
			if (instance_exists(COLL))
			{
				instance_deactivate_object(COLL);
			}
		}
	}
	until (COLL == noone);
	instance_activate_all();
	//play sound effect
	if (HIT1) {var SND = audio_play_sound(snd_hit1, 0, false); audio_sound_pitch(SND, 0.9+random(0.2));} //hit wall
	if (HIT2) {var SND = audio_play_sound(snd_hit1, 0, false); audio_sound_pitch(SND, 1.8+random(0.2));} //hit enemy
	if (HIT3 and !HIT1) {var SND = audio_play_sound(snd_hit4, 0, false); audio_sound_pitch(SND, 1.5+random(0.2));} //hit wall (indestructible)
	if !HIT1 and !HIT2 {var SND = audio_play_sound(snd_hit3, 0, false); audio_sound_pitch(SND, 0.75+random(0.1));} //hit floor
	//extra effect, shockwave
	if (pwr[pwr_shockwave] == true)
	{
		var DIS = 4;
		var WAVE = instance_create_layer(x+lengthdir_x(DIS, angle), y+lengthdir_y(DIS, angle), layer, obj_shockwave);
		WAVE.image_angle = angle;
		WAVE.direction = angle;
	}
	pickaxe_out = 2; //out and attack is done
}
//click event
//attack start
//hold click is slower than clicking fast
if ((mouse_check_button_pressed(mb_left) or (mouse_check_button(mb_left) and timing >= time_last_attacked + 5)) and pickaxe_out == 0)
{
	//if in range, use pickaxe
	pickaxe_out = true;
	pickaxe_img_index = 0;
	sprite_index = spr_char_attack;
	image_index = 0;
	//every 2 attack sound
	if (attack_count mod attack_sound_mod == 0)
	{
		audio_play_sound(snd_attack, 0, false);
	}
	attack_count += 1;
}
//buffer new attack or end attack
else if (pickaxe_img_index >= sprite_get_number(pickaxe_sprite) and pickaxe_out >= 1)
{
	if (attack_buffer == false)
	{
		pickaxe_out = false;
		attack_buffer = false;
		pickaxe_img_index = 0;
		time_last_attacked = timing;
		sprite_index = spr_char;
	}
	//buffer new attack immediately
	else
	{
		angle = point_direction(x, y, mouse_x, mouse_y); //update angle between hits
		pickaxe_img_index = 0;
		pickaxe_out = 1;
		image_index = 0;
		attack_buffer = false;
		//every 2 attack sound
		if (attack_count mod attack_sound_mod == 0)
		{
			audio_play_sound(snd_attack, 0, false);
		}
		attack_count += 1;
	}
}
//Fullscreen
if (keyboard_check_pressed(vk_escape) or keyboard_check_pressed(vk_f4))
{
	window_set_fullscreen(!window_get_fullscreen());
}
#endregion
#region Collision
if (phasing == true or place_meeting(x, y, par_solid))
{
	//just move ignore collision if phasing or stuck in solid
	x += movex;
	y += movey;
}
else
{
	if (!place_meeting(x+movex, y, par_solid))
	{
		x += movex;
	}
	if (!place_meeting(x, y+movey, par_solid))
	{
		y += movey;
	}
	with (instance_place(x, y, obj_activator))
	{
		with (par_monster_spawn)
		{
			if (index = other.index and hp > 0 and activate == false)
			{
				activate = true;
				alarm[1] = 2; //create monster almost immediately
			}
		}
	}
	with (instance_place (x, y, obj_activator_view))
	{
		with (obj_UI)
		{
			start = other.start;
			//full volume
			if (start == 0 or start == 1 or start == 2)
			{
				audio_sound_gain(mus_main, VOLUME_MULT, 0);
			}
			else //start == 3
			{
				audio_sound_gain(mus_main, 0.6*VOLUME_MULT, 0);
			}
		}
	}
	with (instance_place(x, y, obj_activator_arrow))
	{
		with (obj_wall_arrow)
		{
			if (index = other.index and activate == false)
			{
				activate = true;
				alarm[1] = 2;
			}
		}
	}
	with (instance_place(x, y, obj_activator_arrow_off))
	{
		with (obj_wall_arrow)
		{
			if (index = other.index and activate == true)
			{
				activate = false;
			}
		}
	}
	with (instance_place(x, y, obj_activator_boss))
	{
		with (obj_monster_boss)
		{
			if (activate == false)
			{
				activate = true;
				alarm[1] = 2;
			}
		}
	}
	with (instance_place(x, y, obj_coin))
	{
		coins += 1;
		instance_create_layer(x-1, y-2, layer_get_name("UI"), obj_text);
		var SND = audio_play_sound(snd_coin, 0, false);
		audio_sound_pitch(SND, 1+random(0.2)); //random pitch
		instance_destroy();
	}
	if (hit == false)
	{
		with (instance_place(x, y, par_monster))
		{
			if (dmg > 0 and activate == true)
			{
				other.hit = true;
				other.alarm[11] = 35;
				other.hp -= dmg;
				other.hit_count += 1;
				var SND = audio_play_sound(snd_ouch, 0, false);
				audio_sound_pitch(SND, 0.95+random(0.1));
				//playsound
			}
		}
		with (instance_place(x, y, obj_arrow))
		{
			other.hit = true;
			other.alarm[11] = 35;
			other.hp -= dmg;
			other.hit_count += 1;
			var SND = audio_play_sound(snd_ouch, 0, false);
			audio_sound_pitch(SND, 0.95+random(0.1));
			instance_destroy();
		}
	}
}
//if out of bounds go back in bounds
x = clamp(x, 0, room_width);
y = clamp(y, 0, room_height);
#endregion
#region Animate
if (x != xprevious or y != yprevious or pickaxe_out > 0)
{
	image_index += animate_speed;
}
else
{
	image_index = 0;
}
#endregion