/// @description Step
timing += 1;

if (activate == true)
{
	pwr[pwr_power] = obj_char.pwr[pwr_power];
	pwr[pwr_range] = obj_char.pwr[pwr_range];
	pwr[pwr_shockwave] = obj_char.pwr[pwr_shockwave];
	pickaxe_damage = obj_char.pickaxe_damage; //matches your damage
	//keep following character
	direction = point_direction(x, y, obj_char.x, obj_char.y);
	if (obj_char.hit == true) { direction = (direction+180 mod 360);}
	angle = direction;
	//update pickaxe image index
	pickaxe_img_index += pickaxe_img_speed;
	
	if (obj_char.hit == true or floor(timing/60) mod 3 == 0)
	{
		movespeed = 0.5;
	}
	else
	{
		movespeed = 1;
	}
	if pickaxe_out > 0
	{
		animate_speed = 0.25;
	}
	else
	{
		animate_speed = 0.2;
	}

	//flash every other step if hit
	if (hit == true and timing mod 2 = 0)
	{
		image_alpha = 0;
	}
	else
	{
		if (floor(timing/2) mod 2 == 0)
		{
			image_alpha = 0.6;
		}
		else
		{
			image_alpha = 0.9;
		}
	}

	if (activate == true)
	{
		speed = movespeed;
	}
	else
	{
		speed = 0;
	}
	#region Swings axe at you!!!
	//if we've reached the correct frame, throw out attack/shockwave
	if (pickaxe_out == 1 and pickaxe_img_index >= pickaxe_img_speed * 20)
	{
		var HIT1 = false; var HIT2 = false; var HIT3 = false;
		var STR = 0;
		//base effect, attack/mine rocks
		if (obj_char.pwr[pwr_range] == true)
		{
			var DIS = 13; var SIZE = 12;
		}
		else
		{
			var DIS = 10; var SIZE = 10;
		}
		var XX = x+lengthdir_x(DIS, angle) - (SIZE/2); var YY = y+lengthdir_y(DIS, angle) - (SIZE/2);
		//check for boulders first (prevents bugs)
		do
		{
			var COLL = collision_rectangle(XX, YY, XX+(SIZE*sign(XX)), YY+(SIZE*sign(YY)), par_boulder, false, true);
			if (COLL != noone)
			{
				scr_hit(COLL, pickaxe_damage);
				instance_deactivate_object(COLL);
				HIT1 = true;
			}
		}
		until (COLL == noone);
		//now check for everything else
		do
		{
			var COLL = collision_rectangle(XX, YY, XX+(SIZE*sign(XX)), YY+(SIZE*sign(YY)), par_canhit, false, true);
			//var COLL = collision_line(x, y, x+lengthdir_x(DIS, angle), y+lengthdir_y(DIS, angle), par_canhit, true, true);
			if (COLL != noone)
			{
				if (COLL.object_type == ot_char)
				{
					COLL.hit = true;
					COLL.alarm[11] = 35;
					COLL.hp -= dmg;
					COLL.hit_count += 1;
					var SND = audio_play_sound(snd_ouch, 0, false);
					audio_sound_pitch(SND, 0.95+random(0.1));
				}
				
				var TYPE = COLL.object_type; //record now, in case dies
				if (TYPE == ot_wall)
				{
					var STR = COLL.strength;
				}
				var SUCCESS = scr_hit(COLL, pickaxe_damage);
				if (TYPE == ot_wall)
				{
					if (STR < 0 or !SUCCESS)
					{
						HIT3 = true;
					}
					else
					{
						HIT1 = true;
					}
				}
				else if (TYPE == ot_enemy)
				{
					HIT2 = true;
				}
				if (instance_exists(COLL))
				{
					instance_deactivate_object(COLL);
				}
			}
		}
		until (COLL == noone);
		instance_activate_all();
		//play sound effect
		if (HIT1) {var SND = audio_play_sound(snd_hit1, 0, false); audio_sound_pitch(SND, 0.9+random(0.2));} //hit wall
		if (HIT2) {var SND = audio_play_sound(snd_hit1, 0, false); audio_sound_pitch(SND, 1.8+random(0.2));} //hit enemy
		if (HIT3 and !HIT1) {var SND = audio_play_sound(snd_hit4, 0, false); audio_sound_pitch(SND, 1.5+random(0.2));} //hit wall (indestructible)
		if !HIT1 and !HIT2 {var SND = audio_play_sound(snd_hit3, 0, false); audio_sound_pitch(SND, 0.75+random(0.1));} //hit floor
		//extra effect, shockwave
		/*if (obj_char.pwr[pwr_shockwave] == true)
		{
			var DIS = 4;
			var WAVE = instance_create_layer(x+lengthdir_x(DIS, angle), y+lengthdir_y(DIS, angle), layer, obj_shockwave);
			WAVE.image_angle = angle;
			WAVE.direction = angle;
			pickaxe_out = 2; //out and attack is done
		}*/
	}
	//end attack
	if (pickaxe_img_index >= sprite_get_number(pickaxe_sprite) and pickaxe_out >= 1)
	{
		pickaxe_out = false;
		pickaxe_img_index = 0;
		time_last_attacked = timing;
		sprite_index = spr_char;
	}
	#endregion
	#region Animate
	if (x != xprevious or y != yprevious or pickaxe_out > 0)
	{
		image_index += animate_speed;
	}
	else
	{
		image_index = 0;
	}
	#endregion
}