/*********
	MouseLock
	===========
	Author: jonathanhagglund@live.com
	License: MIT

	Thanks to: http://jacksonyarr.com/
**********/
document.addEventListener('pointerlockchange', changeCallback, false);
document.addEventListener('mozpointerlockchange', changeCallback, false);
document.addEventListener('webkitpointerlockchange', changeCallback, false);

var mouseLock = new Object(),
		canvas = document.getElementById("canvas");

canvas.onclick = function() {
	canvas.requestPointerLock = canvas.requestPointerLock || canvas.mozRequestPointerLock || canvas.webkitRequestPointerLock;
	// Ask the browser to lock the pointer
	canvas.requestPointerLock();
}

function changeCallback(e) {
		if (document.pointerLockElement === canvas || document.mozPointerLockElement === canvas || document.webkitPointerLockElement === canvas) {
			// we've got a pointerlock for our canvas, add a mouselistener
			document.addEventListener("mousemove", moveCallback, false);
		} else {
			// pointer lock is no longer active, remove mouse move listener
			document.removeEventListener("mousemove", moveCallback, false);
		}
};

function moveCallback(e) {
	var movementX = e.movementX || e.mozMovementX || e.webkitMovementX || 0,
			movementY = e.movementY || e.mozMovementY || e.webkitMovementY || 0;
	//Passing mouse movements to GM
	mouseLock.coords(movementX,movementY);
}

function mouseLock_send(coords) {
	var gmRef = window["mouseLock_send"].caller.name;
	if (mouseLock.coords != undefined) {return true;}
	if (gmRef === undefined) {
		gmRef = arguments.callee.caller.toString().match(/function ([^\(]+)/)[1];
	}
	mouseLock.coords = eval("(function(arg1,arg2){"+ gmRef +"(0,0,arg1,arg2);})");
	return false;
}